/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRest {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Context
    protected UriInfo uriInfo;

    public BaseRest() {
        ContextUtility.getHierarchicalMode().set(false);
        ContextUtility.getIncludeInstanceContexts().set(false);
    }

    protected boolean isRequesterAllowedToPerformHierarchicalRequests() {
        return true;
    }

    protected void checkHierarchicalMode() {
        try {
            List hierarchicalQueryParameterList = (List)this.uriInfo.getQueryParameters().get((Object)"hierarchical");
            if (hierarchicalQueryParameterList != null && hierarchicalQueryParameterList.size() > 0) {
                boolean h;
                String hierarchicalBooleanString = (String)hierarchicalQueryParameterList.get(0);
                boolean hierarchical = Boolean.valueOf(hierarchicalBooleanString);
                boolean bl = h = hierarchical && this.isRequesterAllowedToPerformHierarchicalRequests();
                if (h) {
                    this.logger.info("The request was performed in hierarchical mode and the requester is allowed. Going to set hierarchical mode.");
                    ContextUtility.getHierarchicalMode().set(h);
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("Unable to properly set the Hierarchical Mode is set", (Object)t.getMessage());
        }
    }

    protected boolean isRequesterAllowedToRequestInstancesContexts() {
        return true;
    }

    protected void checkIncludeInstancesContexts() {
        try {
            List includeContextsQueryParameterList = (List)this.uriInfo.getQueryParameters().get((Object)"includeContextsInHeader");
            if (includeContextsQueryParameterList != null && includeContextsQueryParameterList.size() > 0) {
                boolean i;
                String includeContextsBooleanString = (String)includeContextsQueryParameterList.get(0);
                boolean includeContexts = Boolean.valueOf(includeContextsBooleanString);
                boolean bl = i = includeContexts && this.isRequesterAllowedToRequestInstancesContexts();
                if (i) {
                    this.logger.info("The requet to include the contexts in header is allowed.");
                    ContextUtility.getIncludeInstanceContexts().set(true);
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("Unable to properly set the Hierarchical Mode is set", (Object)t.getMessage());
        }
    }
}

