/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.types;

import java.util.HashMap;
import java.util.Map;
import org.gcube.informationsystem.resourceregistry.types.CachedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypesCache {
    private static Logger logger = LoggerFactory.getLogger(TypesCache.class);
    private static TypesCache typesCache;
    protected final Map<String, CachedType<?>> cachedTypes = new HashMap();

    public static synchronized TypesCache getInstance() {
        if (typesCache == null) {
            typesCache = new TypesCache();
        }
        return typesCache;
    }

    private TypesCache() {
    }

    public CachedType<?> getCachedType(String typeName) {
        CachedType cachedType = (CachedType)this.cachedTypes.get(typeName);
        if (cachedType == null) {
            logger.trace("{} not in cache. Going to create {} instance", (Object)typeName, (Object)CachedType.class.getSimpleName());
            cachedType = new CachedType(typeName);
            this.cachedTypes.put(typeName, cachedType);
        }
        return cachedType;
    }
}

