package org.gcube.informationsystem.resourceregistry.utils;

import java.security.Key;

import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;

import com.orientechnologies.orient.core.record.impl.ODocument;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class EncryptedOrient extends ODocument {
	
	public static final String NAME = "Encrypted";
	public static final String VALUE = "value";
	
	protected String decryptedValue;
	protected String dbEncryptedValue;
	protected String contextEncryptedValue;
	
	public EncryptedOrient() {
		super(EncryptedOrient.NAME);
	}
	
	protected EncryptedOrient(String iClassName) {
		super(iClassName);
	}

	public String getEncryptedValue() {
		return this.field(EncryptedOrient.VALUE);
	}

	public void setEncryptedValue(String encryptedValue) {
		this.field(EncryptedOrient.VALUE, encryptedValue);
	}
	
	@Override
	public String toJSON(String iFormat) {
		return super.toJSON(iFormat);
	}

	
	public String getDecryptedValue() {
		return decryptedValue;
	}

	public String getDbEncryptedValue() {
		return dbEncryptedValue;
	}

	public String getContextEncryptedValue() {
		return contextEncryptedValue;
	}
	
	public void setDecryptedValue(String decryptedValue, boolean setEncryptedForContext) throws Exception {
		this.decryptedValue = decryptedValue;
		
		// Encrypting with DB Key
		Key databaseKey = DatabaseEnvironment.getDatabaseKey();
		this.dbEncryptedValue = StringEncrypter.getEncrypter().encrypt(decryptedValue, databaseKey);
		
		// Encrypting with Context Key (default key)
		this.contextEncryptedValue = StringEncrypter.getEncrypter().encrypt(decryptedValue);
		
		
		if(setEncryptedForContext) {
			setEncryptedValue(contextEncryptedValue);
		}else {
			setEncryptedValue(dbEncryptedValue);
		}
		
	}
	
}
