/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts.relations;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.Map;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isparentof.IsParentOfAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isparentof.IsParentOfNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.contexts.entities.ContextManagement;
import org.gcube.informationsystem.resourceregistry.contexts.security.ContextSecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.relations.RelationElementManagement;
import org.gcube.informationsystem.types.reference.entities.EntityType;

public class IsParentOfManagement
extends RelationElementManagement<ContextManagement, ContextManagement, EntityType, EntityType> {
    public IsParentOfManagement() {
        super(AccessType.IS_PARENT_OF, Context.class, Context.class);
    }

    public IsParentOfManagement(ODatabaseDocument oDatabaseDocument) throws ResourceRegistryException {
        this();
        this.oDatabaseDocument = oDatabaseDocument;
        this.getWorkingContext();
        this.includeSource = false;
        this.includeTarget = true;
        this.forceIncludeMeta = true;
        this.forceIncludeAllMeta = true;
    }

    public Map<UUID, JsonNode> getAffectedInstances() {
        throw new UnsupportedOperationException();
    }

    protected SecurityContext getWorkingContext() throws ResourceRegistryException {
        if (this.workingContext == null) {
            this.workingContext = ContextSecurityContext.getInstance();
        }
        return this.workingContext;
    }

    protected IsParentOfNotFoundException getSpecificNotFoundException(NotFoundException e) {
        return new IsParentOfNotFoundException(e.getMessage(), e.getCause());
    }

    protected IsParentOfAlreadyPresentException getSpecificAlreadyPresentException(String message) {
        return new IsParentOfAlreadyPresentException(message);
    }

    public JsonNode createCompleteJsonNode() throws ResourceRegistryException {
        JsonNode relation = this.serializeSelfAsJsonNode();
        try {
            OVertex source = ((OEdge)this.element).getVertex(ODirection.OUT);
            ContextManagement sourceContextManagement = new ContextManagement(this.oDatabaseDocument);
            sourceContextManagement.setElement((OElement)source);
            if (this.includeSource) {
                ((ObjectNode)relation).replace("source", sourceContextManagement.serializeSelfAsJsonNode());
            }
            OVertex target = ((OEdge)this.element).getVertex(ODirection.IN);
            ContextManagement targetContextManagement = new ContextManagement(this.oDatabaseDocument);
            targetContextManagement.setElement((OElement)target);
            if (this.includeTarget) {
                ((ObjectNode)relation).replace("target", targetContextManagement.serializeSelfAsJsonNode());
            }
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw new ResourceRegistryException((Throwable)e);
        }
        return relation;
    }

    protected ContextManagement newSourceEntityManagement() throws ResourceRegistryException {
        return new ContextManagement(this.oDatabaseDocument);
    }

    protected ContextManagement newTargetEntityManagement() throws ResourceRegistryException {
        return new ContextManagement(this.oDatabaseDocument);
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    public void sanityCheck() throws SchemaViolationException, ResourceRegistryException {
    }

    protected void checksourceAndTargetEntityCompliancy() throws NotFoundException, AvailableInAnotherContextException, SchemaViolationException, ResourceRegistryException {
    }
}

