/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.utils;

import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.gcube.com.fasterxml.jackson.core.JsonParseException;
import org.gcube.com.fasterxml.jackson.databind.JsonMappingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.informationsystem.model.reference.properties.Metadata;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.utils.MetadataOrient;
import org.gcube.informationsystem.resourceregistry.utils.OrientDBUtility;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MetadataUtility {
    private static final Logger logger = LoggerFactory.getLogger(MetadataUtility.class);

    public static String getUser() {
        String user = "UNKNOWN_USER";
        try {
            user = SecretManagerProvider.instance.get().getUser().getUsername();
        }
        catch (Exception e) {
            logger.error("Unable to retrieve user. {} will be used", (Object)user);
        }
        return user;
    }

    public static Metadata createMetadata() {
        MetadataOrient metadata = new MetadataOrient();
        String creator = MetadataUtility.getUser();
        metadata.setCreatedBy(creator);
        metadata.setLastUpdateBy(creator);
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat ft = new SimpleDateFormat("E yyyy.MM.dd 'at' hh:mm:ss a zzz");
        logger.trace("Setting Last Update and Creation Time to " + ft.format(date));
        metadata.setCreationTime(date);
        metadata.setLastUpdateTime(date);
        return metadata;
    }

    public static Metadata getMetadata(JsonNode jsonNode) throws JsonParseException, JsonMappingException, IOException, ResourceRegistryException {
        if (jsonNode.has("metadata")) {
            ObjectNode metadataNode = (ObjectNode)jsonNode.get("metadata").deepCopy();
            if (metadataNode.isNull()) {
                return null;
            }
            MetadataOrient metadata = new MetadataOrient();
            metadataNode.set("@class", metadataNode.get("type"));
            metadataNode.remove("type");
            metadata.fromJSON(metadataNode.toString());
            return metadata;
        }
        return null;
    }

    public static MetadataOrient getMetadataOrient(ODocument oDocument) throws ResourceRegistryException {
        if (oDocument instanceof MetadataOrient) {
            return (MetadataOrient)oDocument;
        }
        try {
            MetadataOrient metadataOrient = new MetadataOrient();
            String json = OrientDBUtility.toJsonString((ORecord)oDocument);
            Metadata metadata = (Metadata)ElementMapper.unmarshal(Metadata.class, (String)json);
            metadataOrient.setCreatedBy(metadata.getCreatedBy());
            metadataOrient.setCreationTime(metadata.getCreationTime());
            metadataOrient.setLastUpdateBy(metadata.getLastUpdateBy());
            metadataOrient.setLastUpdateTime(metadata.getLastUpdateTime());
            return metadataOrient;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Unable to recreate Metadata. This is really strange and should not occur. Please contact the system administrator.");
        }
    }

    public static Metadata addMetadata(OElement element) {
        Metadata metadata = MetadataUtility.createMetadata();
        element.setProperty("metadata", (Object)metadata);
        return metadata;
    }

    public static Metadata getMetadata(OElement element) throws ResourceRegistryException {
        return (Metadata)OrientDBUtility.getPropertyDocument(Metadata.class, (OElement)element, (String)"metadata");
    }

    public static void updateModifiedByAndLastUpdate(OElement element) throws ResourceRegistryException {
        ODocument oDocument = (ODocument)element.getProperty("metadata");
        String lastUpdateBy = MetadataUtility.getUser();
        oDocument.field("lastUpdateBy", (Object)lastUpdateBy);
        Date lastUpdateTime = Calendar.getInstance().getTime();
        oDocument.field("lastUpdateTime", (Object)lastUpdateTime);
        element.setProperty("metadata", (Object)oDocument);
    }
}

