/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.json.base.entities;

import java.util.List;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.queries.json.base.JsonQueryERElement;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryEntity;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryConsistsOf;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryIsRelatedTo;

public class JsonQueryResource
extends JsonQueryEntity {
    public JsonQueryResource(JsonNode jsonQuery) throws SchemaException, ResourceRegistryException {
        super(jsonQuery, AccessType.RESOURCE);
        this.fieldNamesToRemove.add("consistsOf");
        this.fieldNamesToRemove.add("isRelatedTo");
    }

    public StringBuffer createSelect(StringBuffer stringBuffer, boolean wrapInnerQuery) throws SchemaException, ResourceRegistryException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT FROM ");
        if (wrapInnerQuery) {
            buffer.append("( ");
            buffer.append(stringBuffer);
            buffer.append(")");
        } else {
            buffer.append(this.type);
        }
        if (this.entryPoint || this.size > 1) {
            buffer.append(" WHERE ");
        }
        if (this.size > 1) {
            buffer.append(this.addConstraints(this.jsonNode, null, null));
            if (this.entryPoint) {
                buffer.append(" AND ");
            }
        }
        if (this.entryPoint) {
            buffer.append("@class");
            buffer.append(" INSTANCEOF \"");
            buffer.append(this.type);
            buffer.append("\"");
        }
        return buffer;
    }

    public StringBuffer createTraversalQuery(StringBuffer stringBuffer) throws SchemaException, ResourceRegistryException {
        ArrayNode consistsOfArray;
        ArrayNode isRelatedToArray;
        boolean wrapInnerQuery = false;
        if (this.traverseBack) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("TRAVERSE ");
            buffer.append(this.direction.name().toLowerCase());
            buffer.append("V(\"");
            buffer.append(this.type);
            buffer.append("\") FROM ( ");
            buffer.append(stringBuffer);
            buffer.append(")");
            stringBuffer = buffer;
            wrapInnerQuery = true;
        }
        if ((isRelatedToArray = (ArrayNode)this.jsonNode.get("isRelatedTo")) != null && isRelatedToArray.size() > 0) {
            --this.size;
            for (int i = 0; i < isRelatedToArray.size(); ++i) {
                JsonNode isRelatedToJsonNode = isRelatedToArray.get(i);
                JsonQueryIsRelatedTo jsonQueryIsRelatedTo = new JsonQueryIsRelatedTo(isRelatedToJsonNode);
                jsonQueryIsRelatedTo.setRequestedResourceType(this.type);
                jsonQueryIsRelatedTo.setDirectionByJson();
                jsonQueryIsRelatedTo.setTraverseBack(this.traverseBack && i == 0);
                stringBuffer = jsonQueryIsRelatedTo.createTraversalQuery(stringBuffer);
            }
            wrapInnerQuery = true;
        }
        if ((consistsOfArray = (ArrayNode)this.jsonNode.get("consistsOf")) != null && consistsOfArray.size() > 0) {
            --this.size;
            for (int i = 0; i < consistsOfArray.size(); ++i) {
                JsonNode consistsOfJsonNode = consistsOfArray.get(i);
                JsonQueryConsistsOf jsonQueryConsistsOf = new JsonQueryConsistsOf(consistsOfJsonNode);
                jsonQueryConsistsOf.setRequestedResourceType(this.type);
                jsonQueryConsistsOf.setDirection(Direction.IN);
                jsonQueryConsistsOf.setTraverseBack(this.traverseBack || wrapInnerQuery || i != 0);
                stringBuffer = jsonQueryConsistsOf.createTraversalQuery(stringBuffer);
            }
            wrapInnerQuery = true;
        }
        if (!wrapInnerQuery) {
            return this.createSelect(stringBuffer, wrapInnerQuery);
        }
        if (this.entryPoint || this.size > 1) {
            return this.createSelect(stringBuffer, wrapInnerQuery);
        }
        return stringBuffer;
    }

    protected StringBuffer getSpecificMatchQuery(List<JsonQueryERElement> childrenBreadcrumb) throws SchemaException, ResourceRegistryException {
        boolean traverseBack;
        int i;
        StringBuffer newBuffer = new StringBuffer();
        int isRelatedToSize = 0;
        ArrayNode consistsOfArray = (ArrayNode)this.jsonNode.get("consistsOf");
        int consistsOfSize = 0;
        if (consistsOfArray != null) {
            consistsOfSize = consistsOfArray.size();
        }
        int total = consistsOfSize;
        ArrayNode isRelatedToArray = (ArrayNode)this.jsonNode.get("isRelatedTo");
        if (isRelatedToArray != null && isRelatedToArray.size() > 0) {
            --this.size;
            isRelatedToSize = isRelatedToArray.size();
            total += isRelatedToSize;
            for (i = 0; i < isRelatedToSize; ++i) {
                JsonNode isRelatedToJsonNode = isRelatedToArray.get(i);
                JsonQueryIsRelatedTo jsonQueryIsRelatedTo = new JsonQueryIsRelatedTo(isRelatedToJsonNode);
                jsonQueryIsRelatedTo.setRequestedResourceType(this.type);
                jsonQueryIsRelatedTo.setDirectionByJson(true);
                jsonQueryIsRelatedTo.setBreadcrumb(childrenBreadcrumb);
                jsonQueryIsRelatedTo.setPosition(i);
                traverseBack = true;
                jsonQueryIsRelatedTo.setTraverseBack(traverseBack);
                newBuffer = jsonQueryIsRelatedTo.createMatchQuery(newBuffer);
                if (!traverseBack) continue;
                newBuffer.append("\n\t.");
                newBuffer.append(jsonQueryIsRelatedTo.getDirection().name().toLowerCase());
                newBuffer.append("V('");
                newBuffer.append(this.type);
                newBuffer.append("') ");
                newBuffer.append("{ where: ($matched.");
                newBuffer.append(this.getAlias(true));
                newBuffer.append(" == $currentMatch)}");
                if (!this.entryPoint || i >= total - 1) continue;
                newBuffer.append("\n");
            }
        }
        if (consistsOfSize > 0) {
            --this.size;
            for (i = 0; i < consistsOfArray.size(); ++i) {
                JsonNode consistsOfJsonNode = consistsOfArray.get(i);
                JsonQueryConsistsOf jsonQueryConsistsOf = new JsonQueryConsistsOf(consistsOfJsonNode);
                jsonQueryConsistsOf.setRequestedResourceType(this.type);
                jsonQueryConsistsOf.setDirection(Direction.OUT);
                jsonQueryConsistsOf.setBreadcrumb(childrenBreadcrumb);
                jsonQueryConsistsOf.setPosition(isRelatedToSize + i);
                traverseBack = true;
                jsonQueryConsistsOf.setTraverseBack(traverseBack);
                newBuffer = jsonQueryConsistsOf.createMatchQuery(newBuffer);
                if (!traverseBack) continue;
                newBuffer.append("\n\t.");
                newBuffer.append(jsonQueryConsistsOf.getDirection().name().toLowerCase());
                newBuffer.append("V('");
                newBuffer.append(this.type);
                newBuffer.append("')");
                newBuffer.append(" { where: ($matched.");
                newBuffer.append(this.getAlias(true));
                newBuffer.append(" == $currentMatch)}");
                if (!this.entryPoint || i >= consistsOfSize - 1) continue;
                newBuffer.append("\n");
            }
        }
        StringBuffer buffer = new StringBuffer();
        if (!this.entryPoint) {
            buffer.append("\n\t");
            buffer.append(".");
            buffer.append(this.direction.name().toLowerCase());
            buffer.append("V('");
            buffer.append(this.type);
            buffer.append("')");
            this.alias = this.getAlias(true);
            StringBuffer sb = null;
            if (this.size > 0) {
                sb = this.addConstraints(this.jsonNode, null, null);
            }
            buffer.append(" {");
            buffer.append(" as: ");
            buffer.append(this.alias);
            buffer.append(",");
            buffer.append(" where: ");
            if (sb != null && sb.length() > 0) {
                buffer.append("(");
            }
            buffer.append("($currentMatch['@class'] INSTANCEOF '");
            buffer.append(this.type);
            buffer.append("')");
            if (sb != null && sb.length() > 0) {
                buffer.append(" AND (");
                buffer.append(sb);
                buffer.append(")");
                buffer.append(")");
            }
            buffer.append("}");
        }
        buffer.append(newBuffer);
        if (this.entryPoint) {
            buffer.append("\n");
        }
        return buffer;
    }
}

