/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.types.properties;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.environments.types.TypeEnvironment;
import org.gcube.informationsystem.resourceregistry.utils.OrientDBUtility;
import org.gcube.informationsystem.types.reference.properties.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyTypeDefinitionManagement
extends ElementManagement<OElement, PropertyType> {
    private static Logger logger = LoggerFactory.getLogger(PropertyTypeDefinitionManagement.class);
    protected String name;

    public PropertyTypeDefinitionManagement() {
        super(AccessType.PROPERTY_TYPE);
        this.typeName = "PropertyType";
    }

    public PropertyTypeDefinitionManagement(TypeEnvironment typeEnvironment, ODatabaseDocument oDatabaseDocument) throws ResourceRegistryException {
        this();
        this.oDatabaseDocument = oDatabaseDocument;
        this.setWorkingEnvironment((Environment)typeEnvironment);
    }

    public Map<UUID, JsonNode> getAffectedInstances() {
        throw new UnsupportedOperationException();
    }

    protected Environment getWorkingEnvironment() throws ResourceRegistryException {
        if (this.workingEnvironment == null) {
            this.workingEnvironment = TypeEnvironment.getInstance();
        }
        return this.workingEnvironment;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            if (this.element == null) {
                if (this.jsonNode != null) {
                    this.name = this.jsonNode.get("name").asText();
                }
            } else {
                this.name = (String)this.element.getProperty("name");
            }
        }
        return this.name;
    }

    protected JsonNode createCompleteJsonNode() throws ResourceRegistryException {
        return this.serializeSelfAsJsonNode();
    }

    protected OElement reallyCreate() throws AlreadyPresentException, ResourceRegistryException {
        logger.debug("Going to create {} for {}", (Object)"PropertyType", (Object)this.getName());
        return this.createElement();
    }

    protected OElement reallyUpdate() throws NotFoundException, ResourceRegistryException {
        logger.debug("Going to update {} for {}", (Object)"PropertyType", (Object)this.getName());
        OElement propertyTypeDefinition = this.getElement();
        propertyTypeDefinition = this.updateProperties(this.oClass, propertyTypeDefinition, this.jsonNode, this.ignoreKeys, this.ignoreStartWithKeys);
        return propertyTypeDefinition;
    }

    protected void reallyDelete() throws NotFoundException, ResourceRegistryException {
        logger.debug("Going to remove {} for {}", (Object)"EntityType", (Object)this.getName());
        this.getElement().delete();
    }

    public OElement getElement() throws NotFoundException, ResourceRegistryException {
        if (this.element == null) {
            try {
                this.element = this.retrieveElement();
            }
            catch (NotFoundException e) {
                throw e;
            }
            catch (ResourceRegistryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ResourceRegistryException((Throwable)e);
            }
        } else if (this.reload) {
            this.element.reload();
        }
        return this.element;
    }

    public OElement retrieveElement() throws NotFoundException, ResourceRegistryException {
        try {
            if (this.getName() == null) {
                throw new NotFoundException("null name does not allow to retrieve the Element");
            }
            String select = "SELECT FROM " + this.typeName + " WHERE " + "name" + " = \"" + this.getName() + "\"";
            OResultSet resultSet = this.oDatabaseDocument.query(select, new HashMap());
            if (resultSet == null || !resultSet.hasNext()) {
                String error = String.format("No %s with name %s was found", this.typeName, this.getName());
                logger.info(error);
                throw new NotFoundException(error);
            }
            OResult oResult = resultSet.next();
            OElement element = ElementManagementUtility.getElementFromOptional((Optional)oResult.getElement());
            logger.trace("{} with id {} is : {}", new Object[]{this.typeName, this.getName(), OrientDBUtility.getAsStringForLogging((ORecord)element)});
            if (resultSet.hasNext()) {
                throw new ResourceRegistryException("Found more than one " + this.typeName + " with name " + this.getName() + ". This is a fatal error please contact Admnistrator");
            }
            return element;
        }
        catch (NotFoundException e) {
            throw this.getSpecificNotFoundException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    protected OElement createElement() throws AlreadyPresentException, ResourceRegistryException {
        try {
            this.element = new ODocument(this.typeName);
            this.updateProperties(this.oClass, this.element, this.jsonNode, this.ignoreKeys, this.ignoreStartWithKeys);
            logger.debug("Created {} is {}", (Object)"PropertyType", (Object)OrientDBUtility.getAsStringForLogging((ORecord)this.element));
            return this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{OElement.class.getSimpleName(), this.accessType.getName(), this.typeName, this.jsonNode, e});
            throw new ResourceRegistryException("Error Creating " + this.typeName + " with " + this.jsonNode, e.getCause());
        }
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    protected NotFoundException getSpecificNotFoundException(NotFoundException e) {
        return new SchemaNotFoundException(e.getMessage(), e.getCause());
    }

    protected AlreadyPresentException getSpecificAlreadyPresentException(String message) {
        return new SchemaAlreadyPresentException(message);
    }

    public void sanityCheck() throws SchemaViolationException, ResourceRegistryException {
    }
}

