/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.generic;

import java.net.MalformedURLException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.apache.axis.Constants;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.informationsystem.publisher.ISGenericPublisher;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.context.ISPublisherContext;
import org.gcube.informationsystem.collector.stubs.wsdai.DataResourceUnavailableFaultType;
import org.gcube.informationsystem.collector.stubs.wsdai.InvalidResourceNameFaultType;
import org.gcube.informationsystem.collector.stubs.wsdai.NotAuthorizedFaultType;
import org.gcube.informationsystem.collector.stubs.wsdai.ServiceBusyFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.AddDocumentRequestWrapper;
import org.gcube.informationsystem.collector.stubs.wsdaix.AddDocumentsRequest;
import org.gcube.informationsystem.collector.stubs.wsdaix.InvalidCollectionNameFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveDocumentRequestWrapper;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveDocumentResponseWrapper;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveDocumentsRequest;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveDocumentsResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.XMLCollectionAccessPT;
import org.gcube.informationsystem.collector.stubs.wsdaix.XMLWrapperType;
import org.gcube.informationsystem.collector.stubs.wsdaix.service.WsdaixServiceAddressingLocator;
import org.w3c.dom.Document;

class CollectorClient {
    protected static final GCUBELog logger = new GCUBELog(ISGenericPublisher.class);
    protected static final int DEFAULT_CALL_TIMEOUT = 120000;

    CollectorClient() {
    }

    protected static void removeDocuments(EndpointReferenceType endpointReferenceType, GCUBEScope gCUBEScope, URI uRI, URI uRI2, String[] stringArray) throws DataResourceUnavailableFaultType, MalformedURLException, RemoteException, ServiceBusyFaultType, InvalidResourceNameFaultType, InvalidCollectionNameFaultType, NotAuthorizedFaultType {
        RemoveDocumentResponseWrapper[] removeDocumentResponseWrapperArray;
        logger.trace((Object)("Removing document from " + endpointReferenceType.getAddress().toString()));
        RemoveDocumentsRequest removeDocumentsRequest = new RemoveDocumentsRequest();
        removeDocumentsRequest.setDataResourceAbstractName(uRI);
        RemoveDocumentRequestWrapper[] removeDocumentRequestWrapperArray = new RemoveDocumentRequestWrapper[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            removeDocumentRequestWrapperArray[i] = new RemoveDocumentRequestWrapper();
            removeDocumentRequestWrapperArray[i].setDocumentName(stringArray[i]);
        }
        removeDocumentsRequest.setRemoveDocumentRequestWrapper(removeDocumentRequestWrapperArray);
        removeDocumentsRequest.setCollectionName(uRI2);
        XMLCollectionAccessPT xMLCollectionAccessPT = null;
        try {
            xMLCollectionAccessPT = new WsdaixServiceAddressingLocator().getXMLCollectionAccessPTPort(endpointReferenceType);
            xMLCollectionAccessPT = (XMLCollectionAccessPT)GCUBERemotePortTypeContext.getProxy((Remote)xMLCollectionAccessPT, (GCUBEScope)gCUBEScope, (int)CollectorClient.getTimeout(), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (Exception exception) {
            logger.error((Object)"Failed to remove the resource", (Throwable)exception);
        }
        RemoveDocumentsResponse removeDocumentsResponse = xMLCollectionAccessPT.removeDocuments(removeDocumentsRequest);
        for (RemoveDocumentResponseWrapper removeDocumentResponseWrapper : removeDocumentResponseWrapperArray = removeDocumentsResponse.getRemoveDocumentResponseWrapper()) {
            logger.trace((Object)("Document name " + removeDocumentResponseWrapper.getDocumentName()));
            logger.trace((Object)("Returned response from remove operation " + removeDocumentResponseWrapper.getResponse().toString()));
        }
    }

    protected static void addDocuments(EndpointReferenceType endpointReferenceType, GCUBEScope gCUBEScope, URI uRI, URI uRI2, String[] stringArray, Document[] documentArray, Document[] documentArray2) throws Exception {
        Object object;
        XMLWrapperType xMLWrapperType;
        logger.trace((Object)("Sending resource to " + endpointReferenceType.getAddress().toString()));
        AddDocumentsRequest addDocumentsRequest = new AddDocumentsRequest();
        addDocumentsRequest.setDataResourceAbstractName(uRI);
        AddDocumentRequestWrapper[] addDocumentRequestWrapperArray = new AddDocumentRequestWrapper[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            addDocumentRequestWrapperArray[i] = new AddDocumentRequestWrapper();
            addDocumentRequestWrapperArray[i].setDocumentName(stringArray[i]);
            xMLWrapperType = new XMLWrapperType();
            object = new MessageElement("http://www.globus.org/namespaces/2004/06/core", "ISPublisher", (Object)documentArray[i]);
            object.setType(Constants.XSD_ANYTYPE);
            if (documentArray2 != null) {
                try {
                    MessageElement messageElement = new MessageElement("http://www.globus.org/namespaces/2004/06/core", "ISPublisher", (Object)documentArray2[i].getDocumentElement());
                    messageElement.setType(Constants.XSD_ANYTYPE);
                    xMLWrapperType.set_any(new MessageElement[]{object, messageElement});
                }
                catch (Exception exception) {
                    logger.error((Object)("Unable to add the document metadata for " + stringArray[i]), (Throwable)exception);
                    throw exception;
                }
            } else {
                xMLWrapperType.set_any(new MessageElement[]{object});
            }
            addDocumentRequestWrapperArray[i].setData(xMLWrapperType);
        }
        addDocumentsRequest.setAddDocumentRequestWrapper(addDocumentRequestWrapperArray);
        addDocumentsRequest.setCollectionName(uRI2);
        XMLCollectionAccessPT xMLCollectionAccessPT = null;
        try {
            xMLCollectionAccessPT = new WsdaixServiceAddressingLocator().getXMLCollectionAccessPTPort(endpointReferenceType);
            xMLCollectionAccessPT = (XMLCollectionAccessPT)GCUBERemotePortTypeContext.getProxy((Remote)xMLCollectionAccessPT, (GCUBEScope)gCUBEScope, (int)CollectorClient.getTimeout(), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to add document " + stringArray[0]), (Throwable)exception);
        }
        xMLWrapperType = xMLCollectionAccessPT.addDocuments(addDocumentsRequest);
        logger.trace((Object)("Number of response wrappers " + xMLWrapperType.getAddDocumentResponseWrapper().length));
        object = null;
        for (int i = 0; i < xMLWrapperType.getAddDocumentResponseWrapper().length; ++i) {
            object = xMLWrapperType.getAddDocumentResponseWrapper()[i].getResponse().toString();
            logger.trace((Object)("Returned response for " + xMLWrapperType.getAddDocumentResponseWrapper()[i].getDocumentName() + ": " + (String)object));
        }
    }

    private static int getTimeout() {
        try {
            return (Integer)ISPublisherContext.getContext().getProperty("COLLECTOR_CHANNEL_TIMEOUT");
        }
        catch (Exception exception) {
            return 120000;
        }
    }
}

