/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.cache;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReference;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.cache.Srv;
import org.gcube.informationsystem.cache.consistency.manager.ConsistencyManagerIF;

public class SrvRegistry {
    private ConsistencyManagerIF cmi = null;
    private static GCUBELog log = new GCUBELog(SrvRegistry.class);
    private GCUBEScope scope = null;
    private Hashtable<Srv, Srv> srvs = new Hashtable();

    public SrvRegistry(GCUBEScope scope) {
        this.setScope(scope);
    }

    public Srv getService(Srv srv) {
        return this.srvs.get(srv);
    }

    public Srv getService(String srvClass, String srvName) {
        return this.getService(new Srv(srvClass, srvName));
    }

    public boolean addService(Srv srv) {
        srv.setScope(this.getScope());
        srv.setMyManager(this.cmi);
        return this.srvs.put(srv, srv) == null;
    }

    public boolean addService(String srvClass, String srvName) {
        return this.addService(new Srv(srvClass, srvName));
    }

    public boolean delService(Srv srv) {
        return this.srvs.remove(srv) != null;
    }

    public boolean delService(String srvClass, String srvName) {
        return this.delService(new Srv(srvClass, srvName));
    }

    public Set<Srv> getSrvs() {
        Iterator<Srv> it = this.srvs.keySet().iterator();
        HashSet<Srv> srvs = new HashSet<Srv>();
        log.debug((Object)("Adding " + this.srvs.keySet().size() + " services"));
        while (it.hasNext()) {
            Srv srv = it.next();
            log.debug((Object)("Adding '" + srv.toString() + "'"));
            srvs.add(srv);
        }
        log.debug((Object)"Returing registered services");
        return srvs;
    }

    public EndpointReference[] getEPRsFor(Srv srv) throws Exception {
        if (this.srvs.get(srv) == null) {
            this.addService(srv);
        }
        Set<EndpointReference> col = this.srvs.get(srv).getEPRs();
        log.debug((Object)("Number of registered services: " + this.srvs.size()));
        log.debug((Object)("Number of registered services 2: " + this.srvs.keySet().size()));
        return col.toArray(new EndpointReference[0]);
    }

    public EndpointReference[] getEPRsFor(String srvClass, String srvName) throws Exception {
        return this.getEPRsFor(new Srv(srvClass, srvName));
    }

    public EndpointReference[] getEPRsFor(Srv srv, String srvType) throws Exception {
        Set<EndpointReference> col;
        if (this.srvs.get(srv) == null) {
            this.addService(srv);
        }
        if ((col = this.srvs.get(srv).getEPRs(srvType)) == null) {
            throw new Exception("Could not find service type: " + srvType);
        }
        return col.toArray(new EndpointReference[0]);
    }

    public EndpointReference[] getEPRsFor(String srvClass, String srvName, String srvType) throws Exception {
        return this.getEPRsFor(new Srv(srvClass, srvName), srvType);
    }

    protected ConsistencyManagerIF getConsistencyManagerImpl() {
        return this.cmi;
    }

    protected void setConsistencyManagerImpl(ConsistencyManagerIF cmi) {
        this.cmi = cmi;
        log.debug((Object)"Updating the consistency manager pointer to registered services");
        for (Srv srv : this.getSrvs()) {
            log.debug((Object)("Updating the consistency manager pointer to srv '" + srv.toString() + "'"));
            srv.setMyManager(this.cmi);
        }
    }

    protected void setScope(GCUBEScope scope) {
        this.scope = scope;
    }

    protected GCUBEScope getScope() {
        return this.scope;
    }
}

