/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.cache;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import org.gcube.informationsystem.cache.ISCache;
import org.gcube.informationsystem.cache.ISCacheConsistencyManagerMBean;
import org.gcube.informationsystem.cache.ISCacheMM;
import org.gcube.informationsystem.cache.SrvRegistry;
import org.gcube.informationsystem.cache.consistency.manager.ConsistencyManagerIF;

public class ISCacheConsistencyManager
implements ISCacheConsistencyManagerMBean {
    private Set<String> CCManagerFQNames = null;
    private String activeCCM = null;
    private URLClassLoader ucl = (URLClassLoader)ClassLoader.getSystemClassLoader();
    private SrvRegistry registry = null;

    public ISCacheConsistencyManager(ISCache cache) {
        this.setCCManagerFQNames(new HashSet<String>());
        this.registry = cache.getRegistry();
    }

    private Object registerCCManager(Class c) throws Exception {
        Object cm = c.newInstance();
        Class[] car = new Class[]{SrvRegistry.class};
        Object[] args = new Object[]{this.registry};
        c.getMethod("initialize", car).invoke(cm, args);
        ISCacheMM.registerISMBean("org.gcube:type=" + this.registry.getScope().toString() + ",name=" + c.getName(), cm);
        return cm;
    }

    protected void unregisterCCManager(Class c) throws Exception {
        ISCacheMM.unregisterISMBean("org.gcube:type=" + this.registry.getScope().toString() + ",name=" + c.getName());
    }

    @Override
    public boolean addCCManager(String CCManagerFQName) throws Exception {
        try {
            Class.forName(CCManagerFQName).newInstance();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return this.getCCManagerFQNames().add(CCManagerFQName);
    }

    @Override
    public boolean addCCManagerDynamic(String CCManagerFQName, String codebase) throws Exception {
        URL[] urls = new URL[this.ucl.getURLs().length + 1];
        for (int i = 0; i < this.ucl.getURLs().length; ++i) {
            urls[i] = this.ucl.getURLs()[i];
        }
        urls[this.ucl.getURLs().length] = new URL(codebase);
        this.ucl = URLClassLoader.newInstance(urls);
        this.ucl.loadClass(CCManagerFQName);
        return this.getCCManagerFQNames().add(CCManagerFQName);
    }

    @Override
    public boolean delCCManager(String CCManagerFQName) throws Exception {
        this.unregisterCCManager(ClassLoader.getSystemClassLoader().loadClass(CCManagerFQName));
        if (CCManagerFQName.equals(this.getActiveCCM())) {
            this.nullifyActiveCCManager();
        }
        return this.getCCManagerFQNames().remove(CCManagerFQName);
    }

    @Override
    public String[] getCCManagers() {
        return this.getCCManagerFQNames().toArray(new String[0]);
    }

    @Override
    public void setActiveCCManager(String CCManagerFQName) throws Exception {
        if (!this.getCCManagerFQNames().contains(CCManagerFQName)) {
            throw new Exception("CCManager " + CCManagerFQName + " does not exist.");
        }
        Class<?> c = null;
        if (this.getActiveCCM() != null) {
            c = Class.forName(CCManagerFQName);
            this.unregisterCCManager(c);
        }
        c = Class.forName(CCManagerFQName);
        this.registry.setConsistencyManagerImpl((ConsistencyManagerIF)this.registerCCManager(c));
        this.setActiveCCM(CCManagerFQName);
    }

    public void nullifyActiveCCManager() throws Exception {
        this.registry.setConsistencyManagerImpl(null);
        this.setActiveCCM(null);
    }

    void setCCManagerFQNames(Set<String> cCManagerFQNames) {
        this.CCManagerFQNames = cCManagerFQNames;
    }

    Set<String> getCCManagerFQNames() {
        return this.CCManagerFQNames;
    }

    private void setActiveCCM(String activeCCM) {
        this.activeCCM = activeCCM;
    }

    private String getActiveCCM() {
        return this.activeCCM;
    }

    @Override
    public String getActiveCCManager() throws Exception {
        return this.getActiveCCM();
    }
}

