package org.gcube.infrastructure.detachedres.detachedreslibrary.server;

import static org.gcube.common.authorization.client.Constants.authorizationService;

import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.infrastructure.detachedres.detachedreslibrary.server.is.DetachedREsBuilder;
import org.gcube.infrastructure.detachedres.detachedreslibrary.shared.Constants;
import org.gcube.infrastructure.detachedres.detachedreslibrary.shared.re.DetachedREs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class DetachedREsClient {

	private Logger logger = LoggerFactory.getLogger(DetachedREsClient.class);
	private String token;
	private String userName;
	private String scope;

	/**
	 * 
	 */
	public DetachedREsClient() {

	}

	public DetachedREsClient(String token) {
		this.token = token;
	}

	public DetachedREs getDetachedREs() throws Exception {
		retrieveAuthInfo();
		logger.debug("Use: [userName={}, scope={}, token={}]",userName,scope,token);
		return DetachedREsBuilder.build(scope);

	}

	public DetachedREs getDetachedREsInScope(String scope) throws Exception {
		retrieveAuthInfo();
		this.scope=scope;
		logger.debug("Use: [userName={}, scope={}, token={}]",userName,scope,token);
		return DetachedREsBuilder.build(scope);

	}
	
	private void retrieveAuthInfo() throws Exception {
		if (Constants.DEBUG_MODE) {
			logger.debug("Debug Mode");
			userName = Constants.DEFAULT_USER;
			scope = Constants.DEFAULT_SCOPE;
			token = Constants.DEFAULT_TOKEN;
			
			
		} else {
			logger.debug("Production Mode");
			try {
				if (token == null) {
					logger.debug("Retrieving token credentials");
					token = SecurityTokenProvider.instance.get();
				}
				logger.debug("Use token: " + token);
				AuthorizationEntry entry = authorizationService().get(token);
				userName = entry.getClientInfo().getId();
				scope = entry.getContext();
			} catch (Exception e) {
				logger.error("Error Retrieving token credentials: " + e.getLocalizedMessage(), e);
				throw e;
			}

		}
		
	
	}

}
