/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.persistence;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.gcube.common.accounting.node.persistence.RIAccountingData;

public class StatisticsData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long interval = 0L;
    private RIAccountingData.statisticsType type = null;
    private LinkedBlockingQueue<Double> queue = null;
    private HashMap<Long, Long> intervalMapping = new HashMap();

    public StatisticsData(RIAccountingData.statisticsType statisticsType2, long l) {
        this.type = statisticsType2;
        this.interval = l;
        this.queue = new LinkedBlockingQueue(5);
        this.intervalMapping.put(l, new Long(0L));
        this.intervalMapping.put(l * 3L, new Long(2L));
        this.intervalMapping.put(l * 5L, new Long(4L));
    }

    public RIAccountingData.statisticsType getType() {
        return this.type;
    }

    public void setType(RIAccountingData.statisticsType statisticsType2) {
        this.type = statisticsType2;
    }

    public void addStatistics(Double d) throws Exception {
        if (!this.queue.offer(d)) {
            this.queue.take();
            if (!this.queue.offer(d)) {
                throw new Exception();
            }
        }
    }

    public Double getStatistics(Long l) throws Exception {
        if (this.queue.size() == 0) {
            return 0.0;
        }
        Iterator<Double> iterator = this.queue.iterator();
        int n = 0;
        Double d = new Double(0.0);
        while ((long)n <= l && iterator.hasNext()) {
            d = d + iterator.next();
            ++n;
        }
        return d == null || d.equals(0.0) ? Double.valueOf(0.0) : d / (double)n;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long l) {
        this.interval = l;
    }

    public HashMap<Long, Long> getIntervalMapping() {
        return this.intervalMapping;
    }

    public void setIntervalMapping(HashMap<Long, Long> hashMap) {
        this.intervalMapping = hashMap;
    }
}

