/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer.db;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.UUID;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.messaging.common.consumer.ServiceContext;
import org.gcube.messaging.common.consumer.db.DBManager;
import org.gcube.messaging.common.consumer.db.PoolManager;
import org.gcube.messaging.common.messages.NodeAccountingMessage;
import org.gcube.messaging.common.messages.PortalAccountingMessage;
import org.gcube.messaging.common.messages.records.AISRecord;
import org.gcube.messaging.common.messages.records.AdvancedSearchRecord;
import org.gcube.messaging.common.messages.records.AnnotationRecord;
import org.gcube.messaging.common.messages.records.AquamapsRecord;
import org.gcube.messaging.common.messages.records.BaseRecord;
import org.gcube.messaging.common.messages.records.BrowseRecord;
import org.gcube.messaging.common.messages.records.ContentRecord;
import org.gcube.messaging.common.messages.records.DocumentWorkflowRecord;
import org.gcube.messaging.common.messages.records.GenericRecord;
import org.gcube.messaging.common.messages.records.GoogleSearchRecord;
import org.gcube.messaging.common.messages.records.HLRecord;
import org.gcube.messaging.common.messages.records.IntervalRecord;
import org.gcube.messaging.common.messages.records.LoginRecord;
import org.gcube.messaging.common.messages.records.QuickSearchRecord;
import org.gcube.messaging.common.messages.records.ReportRecord;
import org.gcube.messaging.common.messages.records.SimpleSearchRecord;
import org.gcube.messaging.common.messages.records.TSRecord;
import org.gcube.messaging.common.messages.records.WarRecord;
import org.gcube.messaging.common.messages.records.WebAppRecord;

public class AccountingDBManager
extends DBManager
implements Runnable {
    GCUBELog logger = new GCUBELog(AccountingDBManager.class);
    protected static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public AccountingDBManager() {
        this.dbFileBaseFolder = ServiceContext.getContext().getPersistenceRoot().getAbsolutePath() + File.separator + "AccountingDB";
        this.dbName = "accounting";
        this.dbFileName = this.dbFileBaseFolder + File.separator + this.dbName + ".db";
        backupFolder = new File(System.getenv("HOME") + File.separator + "AccountingDBBackup");
        this.queriesFile = new File(GHNContext.getContext().getLocation() + File.separator + (String)ServiceContext.getContext().getProperty("configDir", new boolean[0]) + File.separator + (String)ServiceContext.getContext().getProperty("AccountingDBFile", new boolean[]{true}));
        this.connection = null;
        if (ServiceContext.getContext().getUseEmbeddedDB().booleanValue()) {
            Thread t = new Thread(this);
            t.start();
        }
        this.poolManager = new PoolManager(this.dbName);
    }

    @Override
    protected void connectToMySql() throws Exception {
        this.connection = this.poolManager.getInternalDBConnection();
        this.connection.setAutoCommit(true);
    }

    @Override
    public void open() throws ClassNotFoundException, SQLException, Exception {
        if (this.connection == null) {
            if (ServiceContext.getContext().getUseEmbeddedDB().booleanValue()) {
                this.connectToEmbeddedDB();
            } else {
                this.connectToMySql();
            }
        }
        String testQuery = "SELECT LIMIT 1 1 * FROM NODEINVOCATION";
        DBManager.BaseConsumer baseConsumer = new DBManager.BaseConsumer(){

            @Override
            public void consume(ResultSet resultset) throws Exception {
            }
        };
        try {
            this.queryAndConsume(testQuery, baseConsumer);
        }
        catch (Exception e) {
            this.createDB();
        }
    }

    public void storeNodeAccoutingInfo(IntervalRecord record, NodeAccountingMessage<IntervalRecord> message) {
        this.logger.debug((Object)("INSERT the following RECORD: " + record.toString() + " INTO DB"));
        String startTime = format.format(record.getStartInterval());
        String endTIme = format.format(record.getEndInterval());
        try {
            String expression = "INSERT INTO NODEACCOUNTING VALUES ('" + message.getSourceGHN() + "','" + message.getServiceClass() + "','" + message.getServiceName() + "','" + message.getCallScope() + "','" + startTime + "','" + endTIme + "','" + record.getInterval() + "','" + record.getInvocationNumber() + "','" + record.getAverageInvocationTime() + "','" + record.getIP() + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    public synchronized void storePortalMessage(PortalAccountingMessage<?> message, BaseRecord record) {
        this.logger.debug((Object)("INSERT the following RECORD: " + record.toString() + " INTO DB"));
        String dateTime = format.format(record.getDate());
        String date = dateTime.substring(0, message.getTime().indexOf(" "));
        String time = dateTime.substring(message.getTime().indexOf(" ") + 1);
        String id = UUID.randomUUID().toString();
        try {
            String expression = "INSERT INTO PORTALACCOUNTING VALUES ('" + id + "','" + message.getUser() + "','" + message.getVre() + "','" + date + "','" + time + "','" + record.getClass().getSimpleName() + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
        if (record instanceof AdvancedSearchRecord) {
            this.storeRecord(id, (AdvancedSearchRecord)record);
        } else if (record instanceof SimpleSearchRecord) {
            this.storeRecord(id, (SimpleSearchRecord)record);
        } else if (record instanceof BrowseRecord) {
            this.storeRecord(id, (BrowseRecord)record);
        } else if (record instanceof LoginRecord) {
            this.storeRecord(id, (LoginRecord)record);
        } else if (record instanceof GenericRecord) {
            this.storeRecord(id, (GenericRecord)record);
        } else if (record instanceof ContentRecord) {
            this.storeRecord(id, (ContentRecord)record);
        } else if (record instanceof QuickSearchRecord) {
            this.storeRecord(id, (QuickSearchRecord)record);
        } else if (record instanceof GoogleSearchRecord) {
            this.storeRecord(id, (GoogleSearchRecord)record);
        } else if (record instanceof HLRecord) {
            this.storeRecord(id, (HLRecord)record);
        } else if (record instanceof AISRecord) {
            this.storeRecord(id, (AISRecord)record);
        } else if (record instanceof TSRecord) {
            this.storeRecord(id, (TSRecord)record);
        } else if (record instanceof AnnotationRecord) {
            this.storeRecord(id, (AnnotationRecord)record);
        } else if (record instanceof DocumentWorkflowRecord) {
            this.storeRecord(id, (DocumentWorkflowRecord)record);
        } else if (record instanceof WebAppRecord) {
            this.storeRecord(id, (WebAppRecord)record);
        } else if (record instanceof WarRecord) {
            this.storeRecord(id, (WarRecord)record);
        } else if (record instanceof ReportRecord) {
            this.storeRecord(id, (ReportRecord)record);
        } else if (record instanceof AquamapsRecord) {
            this.storeRecord(id, (AquamapsRecord)record);
        }
    }

    private synchronized void storeRecord(String id, AdvancedSearchRecord record) {
        String expression;
        for (String collectionid : record.getCollections().keySet()) {
            try {
                expression = "INSERT INTO COLLECTION VALUES ('" + id + "','" + collectionid + "','" + (String)record.getCollections().get(collectionid) + "');";
                this.update(expression);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error updating DB", (Throwable)e);
            }
        }
        for (String term : record.getTerms().keySet()) {
            try {
                expression = "INSERT INTO TERM VALUES ('" + id + "','" + term + "','" + (String)record.getTerms().get(term) + "');";
                this.update(expression);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error updating DB", (Throwable)e);
            }
        }
        try {
            String expression2 = "INSERT INTO ADVANCEDSEARCH VALUES ('" + id + "','" + record.getOperator() + "');";
            this.update(expression2);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, SimpleSearchRecord record) {
        for (String collectionid : record.getCollections().keySet()) {
            try {
                String expression = "INSERT INTO COLLECTION VALUES ('" + id + "','" + collectionid + "','" + (String)record.getCollections().get(collectionid) + "');";
                this.update(expression);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error updating DB", (Throwable)e);
            }
        }
        try {
            String expression = "INSERT INTO SIMPLESEARCH VALUES ('" + id + "','" + record.getTerm() + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, BrowseRecord record) {
        for (String collectionid : record.getCollections().keySet()) {
            try {
                String expression = "INSERT INTO COLLECTION VALUES ('" + id + "','" + collectionid + "','" + (String)record.getCollections().get(collectionid) + "');";
                this.update(expression);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error updating DB", (Throwable)e);
            }
        }
        try {
            String expression = "INSERT INTO BROWSE VALUES ('" + id + "','" + record.getBrowseBy() + "','" + (record.isDistinct() ? 1 : 0) + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, LoginRecord record) {
        try {
            String expression = "INSERT INTO LOGIN VALUES ('" + id + "','" + record.getMessage() + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, GenericRecord record) {
        try {
            String expression = "INSERT INTO GENERIC VALUES ('" + id + "','" + record.getMessage() + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, ContentRecord record) {
        try {
            String expression = "INSERT INTO CONTENT VALUES ('" + id + "','" + record.getContentId() + "','" + record.getContentName() + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, GoogleSearchRecord record) {
        try {
            String expression = "INSERT INTO GOOGLESEARCH VALUES ('" + id + "','" + record.getTerm() + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, QuickSearchRecord record) {
        try {
            String expression = "INSERT INTO QUICKSEARCH VALUES ('" + id + "','" + record.getTerm() + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, TSRecord record) {
        try {
            String expression = "INSERT INTO TS VALUES ('" + id + "','" + record.getTitle() + "','" + record.getTSsubType().name() + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, AISRecord record) {
        try {
            String expression = "INSERT INTO AIS VALUES ('" + id + "','" + record.getID() + "','" + record.getName() + "','" + record.getAISsubType().name() + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, AnnotationRecord record) {
        String expression;
        try {
            expression = "INSERT INTO ANNOTATION VALUES ('" + id + "','" + record.getAnnotationName() + "','" + record.getAnnotationSubType().name() + "','" + record.getAnnotationType() + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
        try {
            expression = "INSERT INTO CONTENT VALUES ('" + id + "','" + record.getObjectID() + "','" + record.getObjectName() + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, HLRecord record) {
        try {
            if (record.getHLsubType().compareTo((Enum)HLRecord.HLSubType.HL_WORKSPACE_CREATED) == 0) {
                String expression = "INSERT INTO HL VALUES ('" + id + "','" + "NULL','" + "NULL','" + "NULL','" + record.getHLsubType().name() + "');";
                this.update(expression);
            } else {
                String expression = "INSERT INTO HL VALUES ('" + id + "','" + record.getID() + "','" + record.getName() + "','" + record.getType() + "','" + record.getHLsubType().name() + "');";
                this.update(expression);
                if (record.getHLsubType().compareTo((Enum)HLRecord.HLSubType.HL_ITEM_SENT) == 0) {
                    for (HLRecord.GCUBEUser user : record.getAddresseesUsers()) {
                        String expr = "INSERT INTO GCUBEUSERSADDRESSEES VALUES ('" + id + "','" + user.getUser() + "','" + user.getVre() + "');";
                        this.update(expr);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, ReportRecord record) {
        try {
            String expression = "";
            expression = record.getSubType().compareTo((Enum)ReportRecord.ReportSubType.GENEARATE_REPORT_OUTPUT) != 0 ? "INSERT INTO REPORT VALUES ('" + id + "','" + record.getSubType().name() + "','" + record.getTemplateID() + "','" + record.getTemplateName() + "','" + (record.getSubType().compareTo((Enum)ReportRecord.ReportSubType.CREATE_REPORT) == 0 || record.getSubType().compareTo((Enum)ReportRecord.ReportSubType.OPEN_REPORT) == 0 ? "NULL','" : record.getAuthor() + "','") + "NULL','" + "NULL','" + "NULL');" : "INSERT INTO REPORT VALUES ('" + id + "','" + record.getSubType().name() + "','" + "NULL','" + "NULL','" + "NULL','" + record.getName() + "','" + record.getMimetype() + "','" + record.getType() + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, DocumentWorkflowRecord record) {
        try {
            String expression = "INSERT INTO DOCUMENTWORKFLOW VALUES ('" + id + "','" + record.getSubType().name() + "','" + record.getWorkflowid() + "','" + record.getReportname() + "','" + (record.getSubType().compareTo((Enum)DocumentWorkflowRecord.WorkflowSubType.CREATED_WORKFLOWREPORT_OUTPUT) == 0 ? "NULL','" : record.getStepsNumber() + "','") + (record.getSubType().compareTo((Enum)DocumentWorkflowRecord.WorkflowSubType.DELETED_WORKFLOWREPORT_OUTPUT) == 0 ? "NULL');" : record.getStatus() + "');");
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, WebAppRecord record) {
        try {
            String expr;
            String expression = "INSERT INTO WEBAPP VALUES ('" + id + "','" + record.getSubType().name() + "');";
            this.update(expression);
            for (WebAppRecord.GHN ghn : record.getGhns()) {
                expr = "INSERT INTO GHNDETAIL VALUES ('" + id + "','" + ghn.getGHN_ID() + "','" + ghn.getGHN_NAME() + "');";
                this.update(expr);
            }
            for (WebAppRecord.WebApplication webApp : record.getWebapplications()) {
                expr = "INSERT INTO WEBAPPDETAIL VALUES ('" + id + "','" + webApp.getWEB_APPLICATION_ID() + "','" + webApp.getWEB_APPLICATION_NAME() + "','" + webApp.getWEB_APPLICATION_VERSION() + "');";
                this.update(expr);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, WarRecord record) {
        try {
            String expression = "INSERT INTO WAR VALUES ('" + id + "','" + record.getSubType().name() + "','" + record.getWarId() + "','" + (record.getSubType().compareTo((Enum)WarRecord.WarSubType.WAR_REMOVED) == 0 ? "NULL','" : record.getWarName() + "','") + (record.getSubType().compareTo((Enum)WarRecord.WarSubType.WAR_REMOVED) == 0 ? "NULL','" : record.getAppName() + "','") + (record.getSubType().compareTo((Enum)WarRecord.WarSubType.WAR_REMOVED) == 0 ? "NULL','" : record.getAppVersion() + "','") + (record.getSubType().compareTo((Enum)WarRecord.WarSubType.WAR_REMOVED) == 0 ? "NULL');" : record.getCategory() + "');");
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private synchronized void storeRecord(String id, AquamapsRecord record) {
        try {
            String expression = "INSERT INTO AQUAMAPS VALUES ('" + id + "','" + record.getTitle() + "','" + record.getType() + "','" + record.getAquamapsSubtype().name() + "','" + record.getSpeciesCount() + "','" + record.isGis() + "','" + (record.getAquamapsSubtype().compareTo((Enum)AquamapsRecord.AquamapsSubType.AquamapsSavedItem) == 0 ? "NULL','" : record.getHspecId() + "','") + (record.getAquamapsSubtype().compareTo((Enum)AquamapsRecord.AquamapsSubType.AquamapsGeneration) == 0 ? "NULL');" : record.getObjectID() + "');");
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    @Override
    public void run() {
        do {
            try {
                Thread.sleep(backupIntervalMS);
                this.backup();
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"Unable to sleep", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to backup", (Throwable)e);
            }
        } while (!Thread.interrupted());
    }
}

