/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.messages;

import java.lang.reflect.Field;
import java.util.TreeMap;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.messaging.common.messages.GCUBEMessage;
import org.gcube.messaging.common.messages.MessageField;
import org.gcube.messaging.common.messages.util.Utils;

public class SystemAccountingMessage
extends GCUBEMessage {
    private static final long serialVersionUID = 1L;
    private String serviceClass;
    private String serviceName;
    private String messageType;
    private TreeMap<String, MessageField> fieldMap = new TreeMap();
    public static final String systemAccounting = "ACCOUNTING.SYSTEM";

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public TreeMap<String, MessageField> getFieldMap() {
        return this.fieldMap;
    }

    public void setFieldMap(TreeMap<String, MessageField> fieldMap) {
        this.fieldMap = fieldMap;
    }

    public synchronized void addField(MessageField field) {
        this.fieldMap.put(field.getName(), field);
    }

    public void createTopicName(String scope) {
        ScopeBean bean = new ScopeBean(scope);
        if (bean.is(ScopeBean.Type.INFRASTRUCTURE)) {
            this.topic = Utils.replaceUnderscore(bean.name()) + "." + systemAccounting + "." + Utils.replaceUnderscore(this.sourceGHN);
        } else if (bean.is(ScopeBean.Type.VO)) {
            this.topic = Utils.replaceUnderscore(Utils.getInfraScope(scope)) + "." + Utils.replaceUnderscore(scope) + "." + systemAccounting + "." + Utils.replaceUnderscore(this.sourceGHN);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.messageType + "\t");
        builder.append(this.scope + "\t");
        builder.append(this.serviceClass + "\t");
        builder.append(this.serviceName + "\t");
        builder.append(this.sourceGHN + "\t");
        builder.append(this.time + "\t");
        builder.append(this.topic + "\t");
        for (MessageField field : this.fieldMap.values()) {
            builder.append(field.getName() + "\t");
            builder.append(field.getValue() + "\t");
            builder.append(field.getSqlType() + "\t");
        }
        return builder.toString();
    }

    public void checkReservedField() throws ReservedFieldException {
        Field[] fields = this.getClass().getDeclaredFields();
        Field[] fields2 = GCUBEMessage.class.getDeclaredFields();
        for (Field f : fields) {
            if (!this.fieldMap.containsKey(f.getName())) continue;
            throw new ReservedFieldException("The parameters name " + f.getName() + " is already used by the application");
        }
        for (Field f : fields2) {
            if (!this.fieldMap.containsKey(f.getName())) continue;
            throw new ReservedFieldException("The parameters name " + f.getName() + " is already used by the application");
        }
        if (this.fieldMap.containsKey("id")) {
            throw new ReservedFieldException("The parameters name id is already used by the application");
        }
    }

    public class ReservedFieldException
    extends Exception {
        private static final long serialVersionUID = 2107643850291448530L;

        public ReservedFieldException(String string) {
            super(string);
        }
    }
}

