package org.gcube.messaging.monitoring.probes.ri;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.ghn.GHNConsumer;
import org.gcube.common.core.contexts.ghn.Events.GHNRIRegistrationEvent;
import org.gcube.common.core.contexts.ghn.Events.GHNTopic;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.monitoring.GCUBENotificationProbe;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBEResource.ResourceConsumer;
import org.gcube.common.core.resources.GCUBEResource.ResourceTopic;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.messages.*;
import org.gcube.messaging.common.messages.Test;
import org.gcube.messaging.common.messages.Test.TestType;
import org.gcube.messaging.common.producer.*;

/**
 * Implementation of a RI Notification Probe
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class RINotificationProbe extends GCUBENotificationProbe{


	public RINotificationProbe(){

	}

	/**
	 *  Extends a Resource Consumer with RI ServiceName and ServiceClass
	 *  
	 * @author  Andrea Manzi(CERN)
	 *
	 */
	private class RIResourceConsumer extends ResourceConsumer{

		String serviceName ;
		String serviceClass;
		RIResourceConsumer(String serviceName, String serviceClass){
			this.serviceClass = serviceClass;
			this.serviceName= serviceName;
		}

		/**
		 * {@inheritDoc}
		 */
		protected void onAddScope(GCUBEResource.AddScopeEvent event) {
			for (GCUBEScope scope: event.getPayload()) {
				GCUBELocalProducer.logger.debug("Added Scope " +scope.toString()+ " to RI");	
				Test test = new Test();
				test.setDescription("Added Scope "+scope.toString()+" to RI");
				test.setType(Test.TestType.NOTIFICATION);
				test.setTestResult(scope.toString());
				//check if the scope belong to GHN startScopes
				if (GCUBELocalProducer.checkStartScope(scope))
					test.setPriority(Test.Priority.LOW);
				else test.setPriority(Test.Priority.HIGH);


				try {
					for (GCUBEScope scope1 : GCUBELocalProducer.getMonitoredScope()){
						RIMessage<Test> message = RINotificationProbe.createRIMessage(scope1);
						message.setServiceName(serviceName);
						message.setServiceClass(serviceClass);
						message.setTest(test);
						message.setTimeNow();
						RINotificationProbe.sendRIMessage(message);
					}


				} catch (Exception e) {
					logger.error("Error sending message to broker",e);	
				}
			}
		}
		/**
		 * {@inheritDoc}
		 */
		protected void onRemoveScope(GCUBEResource.RemoveScopeEvent event) {
			for (GCUBEScope scope: event.getPayload()) {
				GCUBELocalProducer.logger.debug("Removed Scope "+scope+"from RI");	
				Test test = new Test();
				test.setDescription("Removed Scope "+scope+" from RI");
				test.setType(Test.TestType.NOTIFICATION);
				test.setTestResult(scope.toString());
				test.setPriority(Test.Priority.HIGH);
				try {
					for (GCUBEScope scope1 : GCUBELocalProducer.getMonitoredScope()){
						RIMessage<Test> message = RINotificationProbe.createRIMessage(scope1);
						message.setServiceName(serviceName);
						message.setServiceClass(serviceClass);
						message.setTest(test);
						message.setTimeNow();
						RINotificationProbe.sendRIMessage(message);
					}

					//send message for removed scope too
					RIMessage<Test> message = RINotificationProbe.createRIMessage(scope);
					message.setServiceName(serviceName);
					message.setServiceClass(serviceClass);
					message.setTest(test);
					message.setTimeNow();
					RINotificationProbe.sendRIMessage(message);

				} catch (Exception e) {
					logger.error("Error sending message to broker",e);	
				}
			}
		}

	}

	@Override
	public void run() throws Exception {

		GHNConsumer ghnManager = new GHNConsumer() {
			/**
			 * {@inheritDoc}
			 */
			protected void onRIRegistration(GHNRIRegistrationEvent event){
					
				try {
					event.getPayload().getInstance().subscribeResourceEvents(new RIResourceConsumer(event.getPayload().getName(),event.getPayload().getServiceClass()), ResourceTopic.ADDSCOPE,ResourceTopic.REMOVESCOPE);
				} catch (Exception e) {
					GCUBELocalProducer.logger.error("Error sending message to broker",e);
				}

			}

		};

		try {
			GHNContext.getContext().subscribeGHNEvents(ghnManager, GHNTopic.RIREGISTRATION);

		}	catch (Exception e)
		{
			logger.error("Error Subscribing to GHN events",e);
			
		}


	}
	/**
	 * Send a RIMessage to the Broker	
	 * @param message the RIMEssage
	 */
	public static void sendRIMessage(RIMessage message){
		new RINotificationProbe().sendMessage(message);
	}
	/**
	 * Creates a RIMessage 	
	 * @param scope a GCUBEScope
	 */
	private static RIMessage<Test> createRIMessage(GCUBEScope scope){
		return new RIMessage<Test>(GHNContext.getContext().getHostnameAndPort(),scope);

	}

	/**
	 * Send a Message to Broker using JMS
	 */
	public  void sendMessage(GCUBEMessage message){
		ActiveMQClient.getSingleton().sendMessage(message,TestType.TEST.name());
	}


}
