/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.nodeaccountingportlet.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import net.sf.csv4j.CSVWriter;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.messaging.accounting.nodeaccountingportlet.stubs.NodeAccountingService;
import org.gcube.messaging.common.consumerlibrary.ConsumerCL;
import org.gcube.messaging.common.consumerlibrary.proxies.Proxies;
import org.gcube.messaging.common.consumerlibrary.query.NodeAccountingQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeAccountingServiceImpl
extends RemoteServiceServlet
implements NodeAccountingService {
    private static Logger logger = LoggerFactory.getLogger(NodeAccountingServiceImpl.class);
    private static final long serialVersionUID = 1L;
    private ConsumerCL library = null;

    public NodeAccountingServiceImpl() {
        try {
        }
        catch (ServletException e) {
            logger.error("Servlet failed to initialize");
        }
    }

    private ASLSession getASLsession() throws Exception {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        String username = httpSession.getAttribute("username").toString();
        ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        return session;
    }

    private String getInfraScope(String scope) {
        ScopeBean sc = new ScopeBean(scope);
        while (!sc.is(ScopeBean.Type.INFRASTRUCTURE)) {
            sc = sc.enclosingScope();
        }
        return sc.toString();
    }

    private ConsumerCL getConsumerLibrary() throws Exception {
        if (this.library == null) {
            try {
                ScopeProvider.instance.set(this.getInfraScope(this.getASLsession().getScope()));
                this.library = (ConsumerCL)Proxies.consumerService().withTimeout(1, TimeUnit.MINUTES).build();
            }
            catch (Exception e) {
                logger.error("Error getting ASL session, returning default", (Throwable)e);
                ScopeProvider.instance.set("/d4science.research-infrastructures.eu");
                this.library = (ConsumerCL)Proxies.consumerService().withTimeout(1, TimeUnit.MINUTES).build();
            }
        }
        return this.library;
    }

    public String export(ArrayList<String[]> records, String name) throws IOException {
        String file = System.getProperty("java.io.tmpdir") + File.separator + name + System.currentTimeMillis() + ".csv";
        FileWriter fileWriter = new FileWriter(file);
        CSVWriter writer = new CSVWriter((Writer)fileWriter);
        for (String[] record : records) {
            writer.writeLine(record);
        }
        fileWriter.flush();
        fileWriter.close();
        return file;
    }

    public String getStartDate() throws Exception {
        NodeAccountingQuery query = null;
        try {
            query = (NodeAccountingQuery)this.getConsumerLibrary().getQuery(NodeAccountingQuery.class, this.library);
            query.setQuery("SELECT DISTINCT startDate FROM NODEACCOUNTING ORDER BY startDate ASC LIMIT 1,1");
            query.query();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        try {
            return (String)((ArrayList)query.getResultsAsArray().get(1)).get(0);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw e;
        }
    }

    public Map<String, ArrayList<String>> getGHNs() throws Exception {
        NodeAccountingQuery query = null;
        try {
            query = (NodeAccountingQuery)this.getConsumerLibrary().getQuery(NodeAccountingQuery.class, this.library);
            return query.getGHNs();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw e;
        }
    }

    public String getRecords(String ghn, String scope, String serviceClass, String serviceName, String sortColumn, String sortDir, int start, int limit, String[] date) throws Exception {
        NodeAccountingQuery query = null;
        try {
            query = (NodeAccountingQuery)this.getConsumerLibrary().getQuery(NodeAccountingQuery.class, this.library);
            query.setLimitClause(Integer.valueOf(start), Integer.valueOf(limit));
            query.setOrderClause(sortColumn + " " + sortDir);
            query.setQuery("SELECT * FROM NODEACCOUNTING " + this.selectDateFilter(date, "WHERE") + (ghn.compareTo("") == 0 ? "" : " AND GHNName ='" + ghn + "'") + (scope.compareTo("") == 0 ? "" : " AND callerScope ='" + scope + "'") + (serviceClass.compareTo("") == 0 ? "" : " AND ServiceClass ='" + serviceClass + "'") + (serviceName.compareTo("") == 0 ? "" : " AND ServiceName ='" + serviceName + "'"));
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        try {
            return query.query();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw e;
        }
    }

    public ArrayList<ArrayList<String>> getScopes() throws Exception {
        NodeAccountingQuery query = null;
        Object results = null;
        try {
            query = (NodeAccountingQuery)this.getConsumerLibrary().getQuery(NodeAccountingQuery.class, this.library);
            query.getScopes();
            return query.getResultsAsArray();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw e;
        }
    }

    public Map<String, ArrayList<String>> getServices() throws Exception {
        NodeAccountingQuery query = null;
        try {
            query = (NodeAccountingQuery)this.getConsumerLibrary().getQuery(NodeAccountingQuery.class, this.library);
            return query.getServices();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw e;
        }
    }

    private String selectDateFilter(String[] date, String delimiter) {
        String ret = "";
        switch (date.length) {
            case 0: {
                break;
            }
            case 1: {
                ret = delimiter + " endDate='" + date[0] + "'";
                break;
            }
            case 2: {
                ret = delimiter + " startDate >= '" + date[0] + "' AND endDate <= '" + date[1] + "'";
            }
        }
        return ret;
    }

    public String getStatistics(String serviceClass, String serviceName, String callerScope, String ghn, String groupBy, String sortColumn, String sortDir, String[] dates) throws Exception {
        NodeAccountingQuery query = null;
        try {
            query = (NodeAccountingQuery)this.getConsumerLibrary().getQuery(NodeAccountingQuery.class, this.library);
            query.setOrderClause(sortColumn + " " + sortDir);
            if (groupBy.compareTo("Date") == 0) {
                groupBy = "DATE(startDate)";
            }
            query.getInvocationPerInterval(serviceClass, serviceName, ghn, dates[0], dates[1], callerScope, groupBy);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        try {
            return query.getResults();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw e;
        }
    }
}

