/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchlibrary.queryelements;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.opensearch.opensearchlibrary.OpenSearchConstants;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElement;
import org.gcube.opensearch.opensearchlibrary.utils.URLEncoder;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class BasicQueryElement
implements QueryElement {
    private Element query = null;
    protected String role = null;
    private String title = null;
    private String totalResults = null;
    private String searchTerms = null;
    private String count = null;
    private String startIndex = null;
    private String startPage = null;
    private String language = null;
    private String inputEncoding = null;
    private String outputEncoding = null;
    private boolean init = false;
    private static final List<String> supportedRoles = Arrays.asList("requests", "example", "related", "correction", "subset", "superset");

    private void parseSearchTerms() throws Exception {
        Attr n = this.query.getAttributeNodeNS(null, "searchTerms");
        if (n != null || (n = this.query.getAttributeNodeNS("http://a9.com/-/spec/opensearch/1.1/", "searchTerms")) != null) {
            try {
                this.searchTerms = URLEncoder.UrlEncode(n.getNodeValue(), "UTF-8");
            }
            catch (Exception e) {
                throw new Exception("Error while processing searchTerms attribute", e);
            }
        }
    }

    private String parseOptionalString(String attribute) throws Exception {
        Attr n = this.query.getAttributeNodeNS(null, attribute);
        if (n != null || (n = this.query.getAttributeNodeNS("http://a9.com/-/spec/opensearch/1.1/", attribute)) != null) {
            return n.getNodeValue();
        }
        return null;
    }

    private String parseInt(String attribute) throws Exception {
        String valueStr = null;
        Attr n = this.query.getAttributeNodeNS(null, attribute);
        if (n != null || (n = this.query.getAttributeNodeNS("http://a9.com/-/spec/opensearch/1.1/", attribute)) != null) {
            try {
                valueStr = n.getNodeValue().trim();
                Integer.parseInt(valueStr);
            }
            catch (Exception e) {
                throw new Exception("Invalid " + attribute + " value", e);
            }
            return valueStr;
        }
        return null;
    }

    private String parseOptionalNonNegativeInt(String attribute) throws Exception {
        String valueStr = null;
        Attr n = this.query.getAttributeNodeNS(null, attribute);
        if (n != null || (n = this.query.getAttributeNodeNS("http://a9.com/-/spec/opensearch/1.1/", attribute)) != null) {
            try {
                valueStr = n.getNodeValue().trim();
                Integer value = Integer.parseInt(valueStr);
                if (value < 0) {
                    throw new Exception(attribute + " attribute must be non-negative");
                }
                return valueStr;
            }
            catch (Exception e) {
                throw new Exception("Invalid " + attribute + " value", e);
            }
        }
        return null;
    }

    private void parseRole() throws Exception {
        Attr n = this.query.getAttributeNodeNS(null, "role");
        if (n == null && (n = this.query.getAttributeNodeNS("http://a9.com/-/spec/opensearch/1.1/", "role")) == null) {
            throw new Exception("Query element lacks role attribute");
        }
        this.role = n.getNodeValue().trim();
    }

    public BasicQueryElement(Element query) {
        this.query = query;
    }

    @Override
    public void parse() throws Exception {
        this.title = this.parseOptionalString("title");
        this.totalResults = this.parseOptionalNonNegativeInt("totalResults");
        this.parseSearchTerms();
        this.count = this.parseOptionalNonNegativeInt("count");
        this.startIndex = this.parseOptionalNonNegativeInt("startIndex");
        this.startPage = this.parseOptionalNonNegativeInt("startPage");
        this.language = this.parseOptionalString("language");
        this.inputEncoding = this.parseOptionalString("inputEncoding");
        this.outputEncoding = this.parseOptionalString("outputEncoding");
        this.parseRole();
        this.init = true;
    }

    @Override
    public String getRole() throws Exception {
        if (!this.init) {
            throw new Exception("Query element not initialized");
        }
        return this.role;
    }

    @Override
    public boolean isRoleSupported() throws Exception {
        if (!this.init) {
            throw new Exception("Query element not initialized");
        }
        return supportedRoles.contains(this.role);
    }

    @Override
    public String getTitle() throws Exception {
        if (!this.init) {
            throw new Exception("Query element not initialized");
        }
        return this.title;
    }

    @Override
    public String getTotalResults() throws Exception {
        if (!this.init) {
            throw new Exception("Query element not initialized");
        }
        return this.totalResults;
    }

    @Override
    public String getSearchTerms() throws Exception {
        if (!this.init) {
            throw new Exception("Query element not initialized");
        }
        return this.searchTerms;
    }

    @Override
    public String getCount() throws Exception {
        if (!this.init) {
            throw new Exception("Query element not initialized");
        }
        return this.count;
    }

    @Override
    public String getStartIndex() throws Exception {
        if (!this.init) {
            throw new Exception("Query element not initialized");
        }
        return this.startIndex;
    }

    @Override
    public String getStartPage() throws Exception {
        if (!this.init) {
            throw new Exception("Query element not initialized");
        }
        return this.startPage;
    }

    @Override
    public String getLanguage() throws Exception {
        if (!this.init) {
            throw new Exception("Query element not initialized");
        }
        return this.language;
    }

    @Override
    public String getInputEncoding() throws Exception {
        if (!this.init) {
            throw new Exception("Query element not initialized");
        }
        return this.inputEncoding;
    }

    @Override
    public String getOutputEncoding() throws Exception {
        if (!this.init) {
            throw new Exception("Query element not initialized");
        }
        return this.outputEncoding;
    }

    @Override
    public boolean describesExampleQuery() {
        return this.role.compareTo("example") == 0;
    }

    @Override
    public Map<String, String> getQueryParameters() throws Exception {
        if (!this.init) {
            throw new Exception("Query element not initialized");
        }
        HashMap<String, String> m = new HashMap<String, String>();
        if (this.searchTerms != null) {
            m.put(OpenSearchConstants.encodedOpenSearchNS + ":searchTerms", this.searchTerms);
        }
        if (this.count != null) {
            m.put(OpenSearchConstants.encodedOpenSearchNS + ":count", this.count);
        }
        if (this.startIndex != null) {
            m.put(OpenSearchConstants.encodedOpenSearchNS + ":startIndex", this.startIndex);
        }
        if (this.startPage != null) {
            m.put(OpenSearchConstants.encodedOpenSearchNS + ":startPage", this.startPage);
        }
        if (this.language != null) {
            m.put(OpenSearchConstants.encodedOpenSearchNS + ":language", this.language);
        }
        if (this.inputEncoding != null) {
            m.put(OpenSearchConstants.encodedOpenSearchNS + ":inputEncoding", this.inputEncoding);
        }
        if (this.outputEncoding != null) {
            m.put(OpenSearchConstants.encodedOpenSearchNS + ":outpuEncoding", this.outputEncoding);
        }
        return m;
    }
}

