/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchlibrary.responseelements;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gcube.opensearch.opensearchlibrary.responseelements.OpenSearchResponse;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class HTMLResponse
extends OpenSearchResponse {
    public HTMLResponse(InputStream in, String encoding, Map<String, String> nsPrefixes) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        BufferedReader bIn = new BufferedReader(new InputStreamReader(in));
        InputSource is = new InputSource(bIn);
        if (encoding.compareTo("UTF-8") != 0) {
            is.setEncoding(encoding);
        }
        this.response = builder.parse(is);
        this.nsPrefixes = nsPrefixes;
        XPathFactory xpFactory = XPathFactory.newInstance();
        XPath xpath = xpFactory.newXPath();
        XPathExpression expr = xpath.compile("/html/head/meta");
        Object result = expr.evaluate(this.response, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        for (int i = 0; i < nodes.getLength(); ++i) {
            String attrName = ((Element)nodes.item(i)).getAttributeNode("name").getNodeValue();
            String attrContent = ((Element)nodes.item(i)).getAttributeNode("content").getNodeValue();
            if (attrName.compareTo("totalResults") == 0) {
                this.totalResults = Integer.parseInt(attrContent.trim());
                continue;
            }
            if (attrName.compareTo("startIndex") == 0) {
                this.startIndex = Integer.parseInt(attrContent.trim());
                continue;
            }
            if (attrName.compareTo("itemsPerPage") != 0) continue;
            this.itemsPerPage = Integer.parseInt(attrContent.trim());
        }
        if (this.totalResults == null && this.startIndex == null) {
            this.containsInfo = false;
            this.isLastPage = null;
            this.isFirstPage = null;
        } else {
            if (this.totalResults == null) {
                this.isLastPage = true;
            }
            if (this.startIndex == null) {
                this.isFirstPage = true;
            }
        }
    }
}

