/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchoperator.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gcube.opensearch.opensearchoperator.resource.OpenSearchResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LocalOpenSearchResource
implements OpenSearchResource {
    private Logger logger = LoggerFactory.getLogger((String)LocalOpenSearchResource.class.getName());
    private String DDUrl = null;
    private URL DDURL = null;
    private Document descriptionDocument = null;
    private String name = null;
    private boolean brokeredResults = false;
    private boolean security = false;
    private Map<String, TransformationSpec> transformationSpecs = new LinkedHashMap<String, TransformationSpec>();
    private TransformerFactory tf = TransformerFactory.newInstance();
    private Map<String, String> parameters = new HashMap<String, String>();

    private void parse(Document document) throws Exception {
        Node n;
        this.name = document.getElementsByTagName("name").item(0).getFirstChild().getNodeValue();
        this.DDUrl = document.getElementsByTagName("descriptionDocumentURI").item(0).getFirstChild().getNodeValue();
        this.DDURL = new URL(this.DDUrl);
        String tmp = document.getElementsByTagName("brokeredResults").item(0).getFirstChild().getNodeValue();
        if (tmp.compareToIgnoreCase("true") == 0 || tmp.compareTo("1") == 0) {
            this.brokeredResults = true;
        }
        this.security = (n = document.getElementsByTagName("security").item(0)) != null;
        NodeList paramsNl = ((Element)document.getElementsByTagName("parameters").item(0)).getElementsByTagName("parameter");
        for (int i = 0; i < paramsNl.getLength(); ++i) {
            Element param = (Element)paramsNl.item(i);
            this.parameters.put(param.getElementsByTagName("fieldName").item(0).getFirstChild().getNodeValue(), param.getElementsByTagName("qName").item(0).getFirstChild().getNodeValue());
        }
        XPathFactory xpFactory = XPathFactory.newInstance();
        int count = 0;
        int found = 0;
        NodeList nl = document.getElementsByTagName("transformation");
        while ((n = nl.item(count)) != null) {
            XPathExpression recordSplitExpr;
            ++count;
            String MIMEType = null;
            Node ch = ((Element)n).getElementsByTagName("MIMEType").item(0);
            MIMEType = ch.getFirstChild().getNodeValue();
            try {
                new MimeType(MIMEType);
            }
            catch (Exception e) {
                this.logger.warn("Malformed MIME type in transformation element in resource " + this.name + ". Ignoring element.", (Throwable)e);
                continue;
            }
            ch = ((Element)n).getElementsByTagName("recordIdXPath").item(0);
            XPathExpression recordIdExpr = null;
            if (ch != null) {
                try {
                    XPath xpath = xpFactory.newXPath();
                    recordIdExpr = xpath.compile(ch.getFirstChild().getNodeValue());
                }
                catch (Exception e) {
                    this.logger.warn("Malformed record id XPath expression in transformation element for " + MIMEType + " in resource " + this.name + ". Ignoring element.", (Throwable)e);
                    continue;
                }
            }
            ch = ((Element)n).getElementsByTagName("recordSplitXPath").item(0);
            try {
                XPath xpath = xpFactory.newXPath();
                recordSplitExpr = xpath.compile(ch.getFirstChild().getNodeValue());
            }
            catch (Exception e) {
                this.logger.warn("Malformed XPath expression in transformation element for " + MIMEType + " in resource " + this.name + ". Ignoring element.", (Throwable)e);
                continue;
            }
            ch = ((Element)n).getElementsByTagName("XSLTLink").item(0);
            URL xsltUrl = null;
            if (ch != null) {
                try {
                    xsltUrl = new URL(ch.getFirstChild().getNodeValue());
                }
                catch (Exception e) {
                    this.logger.warn("Malformed XSLT URL in transformation element for " + MIMEType + " in resource " + this.name + ". Ignoring element.", (Throwable)e);
                    continue;
                }
            }
            HashMap<String, String> presentationInfo = new HashMap<String, String>();
            ch = ((Element)n).getElementsByTagName("presentationInfo").item(0);
            NodeList presentables = ((Element)ch).getElementsByTagName("presentable");
            for (int i = 0; i < presentables.getLength(); ++i) {
                String presentableName = ((Element)presentables.item(i)).getElementsByTagName("fieldName").item(0).getFirstChild().getNodeValue();
                String presentableXPath = ((Element)presentables.item(i)).getElementsByTagName("expression").item(0).getFirstChild().getNodeValue();
                presentationInfo.put(presentableName, presentableXPath);
            }
            this.transformationSpecs.put(MIMEType, new TransformationSpec(xsltUrl, recordSplitExpr, recordIdExpr, presentationInfo));
            ++found;
        }
        if (found == 0) {
            this.logger.error("Could not retrieve a valid transformation specification for resource " + this.name + ". Throwing exception.");
            throw new Exception("Could not retrieve a valid transformation specification for resource " + this.name);
        }
        try {
            URLConnection conn = this.DDURL.openConnection();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.descriptionDocument = builder.parse(new InputSource(in));
            in.close();
        }
        catch (Exception e) {
            this.logger.error("Error while processing Description Document of resource " + this.name);
            throw e;
        }
    }

    public LocalOpenSearchResource(String name, URL DDUrl, boolean brokered) throws IOException, ParserConfigurationException, SAXException {
        this.name = name;
        this.DDUrl = DDUrl.toString();
        this.DDURL = new URL(DDUrl.toString());
        this.brokeredResults = brokered;
        URLConnection conn = DDUrl.openConnection();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        this.descriptionDocument = builder.parse(new InputSource(in));
        in.close();
    }

    public LocalOpenSearchResource(File file, File schemaFile) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        if (schemaFile != null) {
            factory.setValidating(true);
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaFile.getAbsolutePath());
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new SimpleErrorHandler());
        Document document = builder.parse(new InputSource(new BufferedReader(new FileReader(file))));
        this.parse(document);
    }

    public LocalOpenSearchResource(String xml, File schemaFile) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        if (schemaFile != null) {
            factory.setValidating(true);
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaFile.getAbsolutePath());
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new SimpleErrorHandler());
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        this.parse(document);
    }

    public LocalOpenSearchResource(URL url, File schemaFile) throws Exception {
        URLConnection conn = url.openConnection();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        if (schemaFile != null) {
            factory.setValidating(true);
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaFile.getAbsolutePath());
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new SimpleErrorHandler());
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        Document document = builder.parse(new InputSource(in));
        in.close();
        this.parse(document);
    }

    public synchronized void addTransformation(String MIMEType, String recordSplitXPath, String recordIdXPath, URL XSLTUrl, Map<String, String> presentationInfo) throws Exception {
        try {
            new MimeType(MIMEType);
        }
        catch (Exception e) {
            this.logger.error("Malformed MIME type.", (Throwable)e);
            throw new Exception("Malformed MIME type.");
        }
        XPathFactory xpFactory = XPathFactory.newInstance();
        XPath xpath = xpFactory.newXPath();
        XPathExpression recordSplitExpr = xpath.compile(recordSplitXPath);
        XPathExpression recordIdExpr = null;
        if (recordIdXPath != null) {
            xpath = xpFactory.newXPath();
            recordIdExpr = xpath.compile(recordIdXPath);
        }
        if (XSLTUrl != null) {
            try {
                URLConnection conn = XSLTUrl.openConnection();
                this.tf.newTransformer(new StreamSource(new BufferedReader(new InputStreamReader(conn.getInputStream()))));
            }
            catch (Exception e) {
                this.logger.error("Error while parsing XSLT source.", (Throwable)e);
                throw new Exception("Error while parsing XSLT source.");
            }
        }
        if (this.transformationSpecs.containsKey(MIMEType)) {
            this.logger.warn("An XSLT/XPath pair is already present for type " + MIMEType + " . Previous specification will be replaced");
        }
        this.transformationSpecs.put(MIMEType, new TransformationSpec(XSLTUrl, recordSplitExpr, recordIdExpr, presentationInfo));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isBrokered() {
        return this.brokeredResults;
    }

    @Override
    public boolean isSecure() {
        return this.security;
    }

    @Override
    public String getSecuritySpecs() {
        return null;
    }

    @Override
    public Document getDescriptionDocument() {
        return this.descriptionDocument;
    }

    @Override
    public String getDescriptionDocURL() {
        return this.DDUrl;
    }

    @Override
    public synchronized Transformer getTransformer(String MIMEType) throws Exception {
        try {
            new MimeType(MIMEType);
        }
        catch (Exception e) {
            this.logger.error("Malformed MIME Type.", (Throwable)e);
            throw new Exception("Malformed MIME Type");
        }
        TransformationSpec tSpec = this.transformationSpecs.get(MIMEType);
        if (tSpec == null) {
            return null;
        }
        URLConnection conn = null;
        if (tSpec.XSLTUrl != null) {
            conn = tSpec.XSLTUrl.openConnection();
        }
        TransformerFactory ttf = TransformerFactory.newInstance();
        if (tSpec.XSLTUrl != null) {
            return ttf.newTransformer(new StreamSource(new BufferedReader(new InputStreamReader(conn.getInputStream()))));
        }
        return ttf.newTransformer();
    }

    @Override
    public XPathExpression getRecordSplitXPath(String MIMEType) throws Exception {
        try {
            new MimeType(MIMEType);
        }
        catch (Exception e) {
            this.logger.error("Malformed MIME Type.", (Throwable)e);
            throw new Exception("Malformed MIME Type");
        }
        return this.transformationSpecs.get((Object)MIMEType).splitXPath;
    }

    @Override
    public XPathExpression getRecordIdXPath(String MIMEType) throws Exception {
        try {
            new MimeType(MIMEType);
        }
        catch (Exception e) {
            this.logger.error("Malformed MIME Type.", (Throwable)e);
            throw new Exception("Malformed MIME Type");
        }
        return this.transformationSpecs.get((Object)MIMEType).idXPath;
    }

    @Override
    public synchronized Transformer getTransformer() throws Exception {
        if (this.transformationSpecs.isEmpty()) {
            return null;
        }
        URLConnection conn = this.transformationSpecs.get(this.transformationSpecs.keySet().iterator()).XSLTUrl.openConnection();
        return this.tf.newTransformer(new StreamSource(new BufferedReader(new InputStreamReader(conn.getInputStream()))));
    }

    @Override
    public Map<String, String> getPresentationInformation(String MIMEType) {
        return this.transformationSpecs.get((Object)MIMEType).presentationInfo;
    }

    @Override
    public List<String> getTransformationTypes() {
        return new ArrayList<String>(this.transformationSpecs.keySet());
    }

    @Override
    public String getParameterQName(String fieldName) {
        return this.parameters.get(fieldName);
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this.parameters);
    }

    public static void main(String[] args) throws Exception {
        LocalOpenSearchResource o = new LocalOpenSearchResource(new File(System.getenv("HOME") + "/workspace/OpenSearch_Library/Resources/Google.xml"), new File(System.getenv("HOME") + "/workspace/OpenSearch_Library/Schema/OpenSearchResource.xsd"));
        System.out.println(o.getName());
        System.out.println(o.isBrokered());
        System.out.println(o.isSecure());
    }

    private class TransformationSpec {
        public final URL XSLTUrl;
        public final XPathExpression splitXPath;
        public final XPathExpression idXPath;
        public final Map<String, String> presentationInfo;

        public TransformationSpec(URL XSLTUrl, XPathExpression splitXPath, XPathExpression idXPath, Map<String, String> presentationInfo) {
            this.splitXPath = splitXPath;
            this.idXPath = idXPath;
            this.XSLTUrl = XSLTUrl;
            this.presentationInfo = presentationInfo;
        }

        public String toString() {
            return "XSLT=" + (this.XSLTUrl != null ? this.XSLTUrl.toString() : "identity") + " recordSplit=" + this.splitXPath + "  recordId=" + this.idXPath + "  presentationInfo=" + this.presentationInfo.toString();
        }
    }

    private class SimpleErrorHandler
    implements ErrorHandler {
        private SimpleErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            LocalOpenSearchResource.this.logger.warn(e.getMessage(), (Throwable)e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw new SAXException(e.getMessage());
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw new SAXException(e.getMessage());
        }
    }
}

