package org.gcube.portal.event.publisher.lr74.model;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.osgi.service.component.annotations.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * LR7.4 ModelListener bridging LR6.2 group lifecycle events to the event publisher.
 */
@Component(
    immediate = true,
    service = ModelListener.class,
    property = {
        "model.class.name=com.liferay.portal.kernel.model.Group"
    }
)
public class GroupEventPublisherModelListener extends BaseModelListener<Group> implements ModelListener<Group> {

    private static final Log _log = LogFactoryUtil.getLog(GroupEventPublisherModelListener.class);

    @Override
    public void onAfterCreate(Group model) {
        // LR6.2 behavior: publish only for Site groups
        if (!model.isSite()) {
            return;
        }
        publish("GROUP_CREATE", model);
    }

    // LR6.2 did not publish update events for groups

    @Override
    public void onBeforeRemove(Group model) {
        // LR6.2 behavior: publish only for Site groups, on BEFORE remove
        if (!model.isSite()) {
            return;
        }
        publish("GROUP_DELETE", model);
    }

    private void publish(String eventName, Group group) {
        try {
            Map<String, Object> payload = new HashMap<>();
            payload.put("event", eventName);
            payload.put("groupId", group.getGroupId());
            payload.put("companyId", group.getCompanyId());
            payload.put("name", group.getName());
            payload.put("friendlyURL", group.getFriendlyURL());
            // LR6.2 channel name compatibility
            EventPublisherFacade.getInstance().publish("group.event", payload);
        } catch (Throwable t) {
            _log.warn("Failed to publish group event " + eventName + ": " + t.getMessage());
        }
    }
}