/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.notifications;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserNotificationEventLocalServiceUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.Notification;
import org.gcube.portal.databook.shared.NotificationType;
import org.gcube.portal.notifications.CleanerUserNotificationsThread;
import org.gcube.portal.notifications.cache.NotificationsActionCache;
import org.gcube.portal.notifications.database.connections.CassandraClusterConnection;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.jsoup.Jsoup;

/*
 * Exception performing whole class analysis ignored.
 */
public class NotificationCheckerServlet
extends HttpServlet {
    private static final Log logger = LogFactoryUtil.getLog(NotificationCheckerServlet.class);
    private static final String PORTLET_ID = "gcubenotificationsaction_WAR_GCubeCustomNotifications-portlet";
    private static final String FILE_WRONG_NOTIFICATION_EVENT_NAME = "wrong_notification_events.txt";
    private static final String PATH_FILE = "/home/life/";
    public static final int ALERT_MAX_NEW_NOTIFICATIONS = 20;
    private SimpleDateFormat ft = new SimpleDateFormat("E yyyy.MM.dd 'at' hh:mm:ss a zzz");
    LiferayUserManager userManager;
    private Map<String, Boolean> statusCleanNotifications = new ConcurrentHashMap();
    private NotificationsActionCache notificationActions = NotificationsActionCache.getCacheInstance();
    private DatabookStore store = CassandraClusterConnection.getConnection();

    public void init() {
        this.userManager = new LiferayUserManager();
        this.createFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.store == null) {
            logger.error((Object)"Not reachable infrastructure sorry.");
            return;
        }
        String username = request.getParameter("userid");
        String location = request.getParameter("location");
        if (username == null || username.isEmpty()) {
            logger.debug((Object)"userid param not specified, do nothing");
        } else if (location == null || location.isEmpty()) {
            logger.debug((Object)"location param not specified, do nothing");
        } else {
            try {
                if (NotificationCheckerServlet.isNotificationMessagesPageRequest((String)location)) {
                    this.notificationActions.removeKey(username);
                }
                if (this.notificationActions.get(username) != null) {
                    logger.debug((Object)("User's username " + username + " is still in the cache, his notifications won't be refreshed yet"));
                    return;
                }
                this.notificationActions.insert(username, Long.valueOf(new Date().getTime()));
                if (this.statusCleanNotifications.containsKey(username) && !((Boolean)this.statusCleanNotifications.get(username)).booleanValue()) {
                    logger.debug((Object)("There is still a cleaner thread that is removing the notifications of user, returning " + username));
                    return;
                }
                logger.debug((Object)("Asking notifications for " + username + " to Cassandra"));
                GCubeUser userToNotify = this.userManager.getUserByUsername(username);
                if (userToNotify == null) {
                    return;
                }
                long longUserId = userToNotify.getUserId();
                logger.debug((Object)("The user with screename " + username + " has id " + longUserId));
                this.statusCleanNotifications.put(username, false);
                CleanerUserNotificationsThread cleaner = new CleanerUserNotificationsThread(username, longUserId, this);
                cleaner.start();
                cleaner.join();
                if (NotificationCheckerServlet.isNotificationMessagesPageRequest((String)location)) {
                    return;
                }
                ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
                List notificationsToPush = this.store.getUnreadNotificationsByUser(username);
                logger.debug((Object)("There are " + notificationsToPush.size() + " new notifications for " + username));
                int stopIndex = notificationsToPush.size() > 20 ? 20 : notificationsToPush.size();
                logger.debug((Object)("Going to push latest " + stopIndex + " notifications to user " + username));
                for (int i = 0; i < stopIndex; ++i) {
                    Notification notification = (Notification)notificationsToPush.get(i);
                    try {
                        Feed sourceFeed;
                        if (notification.getType().equals((Object)NotificationType.POST_ALERT) && (sourceFeed = this.store.readFeed(notification.getSubjectid())).isApplicationFeed()) continue;
                        String notificationToShow = notification.getDescription();
                        logger.trace((Object)("Initial text is " + notificationToShow));
                        String strippedHtml = Jsoup.parse((String)notificationToShow).text();
                        logger.trace((Object)("After jsoup text is " + strippedHtml));
                        String notificationBody = notification.getSenderFullName() + " " + strippedHtml;
                        notificationBody = notificationBody.length() > 250 ? notificationBody.substring(0, 250) + " ..." : notificationBody;
                        long senderUserId = this.userManager.getUserId(notification.getSenderid());
                        JSONObject payloadJSON = JSONFactoryUtil.createJSONObject();
                        payloadJSON.put("userId", senderUserId);
                        payloadJSON.put("notificationUrl", notification.getUri());
                        payloadJSON.put("notificationBody", notificationBody);
                        payloadJSON.put("notificationId", notification.getKey());
                        UserNotificationEventLocalServiceUtil.addUserNotificationEvent((long)longUserId, (String)"gcubenotificationsaction_WAR_GCubeCustomNotifications-portlet", (long)notification.getTime().getTime(), (long)longUserId, (String)payloadJSON.toString(), (boolean)false, (ServiceContext)serviceContext);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Error while pushing notification with id " + notification.getKey() + " to user (this notification will be skipped) " + username));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error while pushing notifications to user " + username));
            }
            finally {
                this.cleanerFinished(username);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private static boolean isNotificationMessagesPageRequest(String pageUrl) {
        logger.debug((Object)("Url location is " + pageUrl));
        return pageUrl.endsWith("/notifications") | pageUrl.endsWith("/messages");
    }

    private void createFile() {
        File file = new File("/home/life/wrong_notification_events.txt");
        try {
            if (!file.exists()) {
                logger.debug((Object)("Creating file with name " + file.getPath()));
                file.createNewFile();
            } else {
                logger.debug((Object)"File wrong_notification_events.txt already exists");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to create file wrong_notification_events.txt", (Throwable)e);
        }
    }

    synchronized void writeErrorEvent(String lineToWrite) {
        try {
            File file = new File("/home/life/wrong_notification_events.txt");
            if (file.exists()) {
                Date dNow = new Date();
                FileWriter fw = new FileWriter(file.getAbsoluteFile(), true);
                fw.write(lineToWrite + "[" + this.ft.format(dNow) + "]\n");
                fw.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to write line " + lineToWrite), (Throwable)e);
        }
    }

    public void cleanerFinished(String key) {
        if (this.statusCleanNotifications.containsKey(key)) {
            logger.debug((Object)("Setting cleaner thread to finished for user " + key));
            this.statusCleanNotifications.put(key, true);
        }
    }
}

