package org.gcube.portal.events;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.gcube.portal.landingpage.LandingPageManager;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;

public class LogoutAction extends Action {
	private static Log _log = LogFactoryUtil.getLog(LogoutAction.class);


	@Override
	public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
		
		_log.info("LogoutAction v. 1 is ON");
		System.out.println("******\n\n\n\n \"LogoutAction v. 1 is ON\"");
		HttpSession session = request.getSession();
		String editAccount = request.getParameter("edit-account");
		String currentVirtualHost = "";
		try {
			currentVirtualHost = request.getServerName();
			if (editAccount != null) {
				System.out.println("******\n\n\n\n editAccount  NOT NULL");
				response.sendRedirect("https://accounts.dev.d4science.org/auth/realms/d4science/account/");
			} else {
				System.out.println("******\n\n\n\n editAccount IS NULL");
			}
		} catch (Exception e) {
			e.printStackTrace();
		} 
	
	}
	/**
	 * Returns custom landing page path after user login
	 * 
	 * @param request
	 * @return
	 * @throws PortalException
	 * @throws SystemException
	 */
	private String getCustomLandingPage(final HttpServletRequest request) throws PortalException, SystemException {
		String customLandingPagePath ="";
		customLandingPagePath = LandingPageManager.getLandingPagePath(request);
		_log.info("Private Site LandingPage Path = " +  customLandingPagePath);
		return customLandingPagePath;
	}		
}