/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.client.upload.progress;

import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgressListener;

import com.extjs.gxt.ui.client.widget.ProgressBar;

/**
 * Updates a {@link ProgressBar} progress and text based on {@link OperationProgressListener} events.
 * @author Federico De Faveri defaveri@isti.cnr.it
 */
public class CreateProgressBarUpdater implements OperationProgressListener {
	
	protected ProgressBar progressBar;

	/**
	 * Creates a new {@link ProgressBar} updater.
	 * @param progressBar the {@link ProgressBar} to update.
	 */
	public CreateProgressBarUpdater(ProgressBar progressBar) {
		this.progressBar = progressBar;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void operationUpdate(long total, long elaborated) {
		switch ((int)elaborated) {
			case CreationStates.CREATE_STATE_SA_CREATION: progressBar.updateProgress(0.25, "creating the Software Archive..."); break;
			case CreationStates.CREATE_STATE_STORE: progressBar.updateProgress(0.5, "storing WAR on Software Repository..."); break;
			case CreationStates.CREATE_STATE_APPROVE: progressBar.updateProgress(0.75, "approving the Software Archive..."); break;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void operationComplete() {
		progressBar.updateProgress(1, "Creation complete.");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void operationFailed(Throwable caught, String reason, String failureDetails) {
		progressBar.updateText("Creation failed: "+reason);
	}

}
