/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.client.upload.source.local;

import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgress;
import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgressSource;
import org.gcube.portlets.user.warmanagementwidget.client.rpc.WarManagementService;
import org.gcube.portlets.user.warmanagementwidget.client.upload.WarImportSession;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * An {@link OperationProgressSource} for the local upload.
 * The {@link OperationProgress} is retrieved through an RPC call.
 * @author Federico De Faveri defaveri@isti.cnr.it
 */
public class LocalUploadProgressSource implements OperationProgressSource {
	
	protected WarImportSession session;

	/**
	 * Creates a new {@link OperationProgressSource} for local upload.
	 * @param session the import session.
	 */
	public LocalUploadProgressSource(WarImportSession session) {
		this.session = session;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void getProgress(AsyncCallback<OperationProgress> callback) {
		WarManagementService.Util.getInstance().getLocalUploadStatus(session.getId(), callback);
	}

}
