package org.gcube.portlets.user.warmanagementwidget.server;

import java.io.File;

import javax.servlet.http.HttpSession;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.user.warmanagementwidget.client.data.WarProfile;
import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgress;
import org.gcube.portlets.user.warmanagementwidget.client.rpc.WarImportException;
import org.gcube.portlets.user.warmanagementwidget.client.rpc.WarManagementService;
import org.gcube.portlets.user.warmanagementwidget.server.csv.ImportSession;
import org.gcube.portlets.user.warmanagementwidget.server.csv.ImportSessionManager;
import org.gcube.portlets.user.warmanagementwidget.server.management.GCubeServiceInterface;
import org.gcube.portlets.user.warmanagementwidget.server.management.ServiceInterface;
import org.gcube.portlets.user.warmanagementwidget.server.util.ProgressManager;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public class WarManagementServiceImpl extends RemoteServiceServlet implements WarManagementService {

	private static final long serialVersionUID = 1733737412247481074L;

	protected Logger logger = Logger.getLogger(WarManagementServiceImpl.class);

	protected ServiceInterface serviceInterface = new GCubeServiceInterface();
	protected GCUBESecurityManager securityManager = new GCUBESecurityManagerImpl() {

		@Override
		public boolean isSecurityEnabled() {
			return false;
		}
	};

	static{
		Logger root = Logger.getLogger("org.gcube.portlets.user.warmanagementwidget");
		root.setLevel(Level.ALL);
	}
	
	protected ASLSession getASLSession()
	{
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		String sessionID = httpSession.getId();
		
		String user = (String) httpSession.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);

		if (user == null) {

			logger.error("WAR MANAGEMENT STARTING IN TEST MODE - NO USER FOUND");

			//for test onlyscope
			user = "test.user";
			httpSession.setAttribute(ScopeHelper.USERNAME_ATTRIBUTE, user);
			ASLSession session = SessionManager.getInstance().getASLSession(sessionID, user);
			session.setScope("/gcube/devsec");
			//session.setScope("/d4science.research-infrastructures.eu/gCubeApps");
			return session;
			
		} else logger.trace("user found in session "+user);
		
		return SessionManager.getInstance().getASLSession(sessionID, user);
	}
	

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String createWarSessionId() {
		logger.info("createSession");
		String sessionId = ImportSessionManager.getInstance().createImportSession().getId();
		logger.trace("sessionId: "+sessionId);
		return sessionId;
	}

	/**
	 * {@inheritDoc}
	 * @throws WarImportException 
	 */
	@Override
	public OperationProgress getLocalUploadStatus(String sessionId) throws WarImportException {
		logger.info("getLocalUploadStatus sessionId: "+sessionId);

		try {
			ImportSession session = ImportSessionManager.getInstance().getSession(sessionId);
			OperationProgress progress = session.getUploadProgress();
			logger.trace("progress: "+progress);
			return progress;
		} catch(Exception e)
		{
			logger.error("Error getting the Local Upload Status", e);
			throw new WarImportException(e.getMessage());
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getWarFileName(String sessionId) throws WarImportException {
		logger.info("getWarFileName sessionId: "+sessionId);

		try {
			ImportSession session = ImportSessionManager.getInstance().getSession(sessionId);
			String warFileName = session.getWarName();
			logger.trace("warFileName: "+warFileName);
			return warFileName;
		} catch(Exception e)
		{
			logger.error("Error getting the warFileNames", e);
			throw new WarImportException(e.getMessage());
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public WarProfile getWarProfile(String warId) throws WarImportException {
		logger.info("getWarProfile warId: "+warId);

		try {
			ASLSession session = getASLSession();
			return serviceInterface.getProfile(session.getScope(), securityManager, warId);
		} catch(Exception e)
		{
			logger.error("Error getting the war profile", e);
			throw new WarImportException(e.getMessage());
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void uploadWar(String sessionId, WarProfile profile, String baseUrl) throws WarImportException {
		logger.info("uploadWa warId: "+sessionId + ", profile: "+profile+", baseUrl: "+ baseUrl);
		try {
			ASLSession aslSession = getASLSession();
			GCUBEScope scope = aslSession.getScope();
			String user = aslSession.getUsername();
			
			ImportSession session = ImportSessionManager.getInstance().getSession(sessionId);
			File warFile = session.getWarFile();
			OperationProgress warUploadProgress = serviceInterface.uploadWar(user, scope, securityManager, sessionId, profile, warFile, baseUrl);
			session.setWarUpload(warUploadProgress);
		} catch(Exception e)
		{
			logger.error("starting the war creation", e);
			throw new WarImportException(e.getMessage());
		}

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public OperationProgress getWarUploadProgress(String sessionId)	throws WarImportException {
		logger.info("getWarUploadProgress sessionId: "+sessionId);

		try {
			ImportSession session = ImportSessionManager.getInstance().getSession(sessionId);
			return session.getWarUploadProgress();
		} catch(Exception e)
		{
			logger.error("Error getting the creation progress", e);
			throw new WarImportException(e.getMessage());
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String deleteWar(String warId) throws WarImportException {
		logger.info("getWarUploadProgress warId: "+warId);
		try {
			ASLSession aslSession = getASLSession();
			GCUBEScope scope = aslSession.getScope();
			String user = aslSession.getUsername();
			
			OperationProgress progress = serviceInterface.deleteWar(user, scope, securityManager, warId);
			return ProgressManager.getInstance().addOperationProgress(progress);
		} catch(Exception e)
		{
			logger.error("Error getting the creation progress", e);
			throw new WarImportException(e.getMessage());
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public OperationProgress getOperationProgress(String operationId) throws WarImportException {
		logger.info("getOperationProgress operationId: "+operationId);
		try {
			return ProgressManager.getInstance().getProgress(operationId);
		} catch(Exception e)
		{
			logger.error("Error getting the creation progress", e);
			throw new WarImportException(e.getMessage());
		}
	}
}
