/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portets.user.message_conversations.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import gwt.material.design.client.constants.Color;
import gwt.material.design.client.constants.IconPosition;
import gwt.material.design.client.constants.IconType;
import gwt.material.design.client.constants.WavesType;
import gwt.material.design.client.ui.MaterialButton;
import gwt.material.design.client.ui.MaterialLabel;
import gwt.material.design.client.ui.MaterialPanel;
import gwt.material.design.client.ui.MaterialRow;
import gwt.material.design.client.ui.MaterialTextArea;
import gwt.material.design.client.ui.MaterialTitle;
import java.util.Date;
import org.gcube.portets.user.message_conversations.client.MessageServiceAsync;
import org.gcube.portets.user.message_conversations.client.Utils;
import org.gcube.portets.user.message_conversations.client.ui.ApplicationView;
import org.gcube.portets.user.message_conversations.client.ui.AttachmentMenu;
import org.gcube.portets.user.message_conversations.client.ui.DisplayMessage;
import org.gcube.portets.user.message_conversations.shared.ConvMessage;
import org.gcube.portets.user.message_conversations.shared.FileModel;
import org.gcube.portets.user.message_conversations.shared.MessageUserModel;

public class DisplayMessage
extends Composite {
    private static DisplayMessageUiBinder uiBinder = (DisplayMessageUiBinder)GWT.create(DisplayMessageUiBinder.class);
    @UiField
    MaterialPanel mainPanel;
    @UiField
    MaterialRow messageAttachmentsBody;
    @UiField
    MaterialButton showMessages;
    @UiField
    MaterialTextArea messageContent;
    @UiField
    MaterialTitle messageSender;
    @UiField
    MaterialTitle messageSubject;
    @UiField
    MaterialTitle messageRecipients;
    private ApplicationView ap;
    private MessageServiceAsync convService;

    public DisplayMessage(MessageServiceAsync convService, ApplicationView ap) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.convService = convService;
        this.ap = ap;
    }

    public void showMessage(ConvMessage m) {
        String recipientsLabel = "";
        for (MessageUserModel r : m.getRecipients()) {
            String fullName = r.getFullName() == null ? r.getUsername() : r.getFullName();
            recipientsLabel = recipientsLabel + fullName + "; ";
        }
        String fullName = m.getOwner().getFullName() == null ? m.getOwner().getUsername() : m.getOwner().getFullName();
        this.messageSender.setTitle(fullName + ", " + Utils.getFormatteDate((Date)m.getDate()));
        this.messageSubject.setTitle(m.getSubject());
        this.messageRecipients.setTitle("To: " + recipientsLabel);
        this.messageContent.setText(m.getContent());
        this.messageRecipients.setVisible(true);
        this.messageContent.setVisible(true);
        this.messageAttachmentsBody.clear();
        this.messageAttachmentsBody.setVisible(m.hasAttachments());
        this.messageAttachmentsBody.add((Widget)new MaterialLabel("Attachments: "));
        int i = 0;
        for (FileModel item : m.getAttachments()) {
            String activator = "item" + i;
            String attachmentName = item.getName().length() > 25 ? item.getName().substring(0, 20) + "..." : item.getName();
            MaterialButton toAdd = new MaterialButton(attachmentName, IconType.ARROW_DROP_DOWN);
            toAdd.setTitle(item.getName());
            AttachmentMenu dd = new AttachmentMenu(this.convService, toAdd, item);
            dd.setActivator(activator);
            dd.setSeparator(true);
            toAdd.setMargin(5.0);
            toAdd.setPaddingRight(5.0);
            toAdd.setPaddingLeft(5.0);
            toAdd.setWaves(WavesType.DEFAULT);
            toAdd.setActivates(activator);
            toAdd.setIconPosition(IconPosition.RIGHT);
            toAdd.setBackgroundColor(Color.RED_DARKEN_1);
            toAdd.getElement().getStyle().setBackgroundImage("none");
            toAdd.getElement().getStyle().setTextTransform(Style.TextTransform.NONE);
            this.messageAttachmentsBody.add((Widget)toAdd);
            this.messageAttachmentsBody.add((Widget)dd);
            ++i;
        }
    }

    @UiHandler(value={"showMessages"})
    void onShowMessages(ClickEvent e) {
        this.ap.showSidePanel();
    }

    MaterialPanel getMainPanel() {
        return this.mainPanel;
    }
}

