/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.List;
import org.gcube.accounting.analytics.Info;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesService;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesServiceData;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesResponse4Service
extends SeriesResponseBuilder {
    protected static Logger logger = LoggerFactory.getLogger(SeriesResponse4Service.class);
    private List<Info> infos;

    public SeriesResponse4Service(List<Info> infos) {
        this.infos = infos;
    }

    public void buildSeriesResponse() throws AccountingManagerServiceException {
        try {
            if (this.infos.size() <= 0) {
                logger.error("Error creating series for service accounting: No data available!");
                throw new AccountingManagerServiceException("No data available!");
            }
            ArrayList<SeriesServiceData> series = new ArrayList<SeriesServiceData>();
            for (Info info : this.infos) {
                JSONObject jso = info.getValue();
                Long duration = jso.getLong("duration");
                Long operationCount = jso.getLong("operationCount");
                Long maxInvocationTime = jso.getLong("maxInvocationTime");
                Long minInvocationTime = jso.getLong("minInvocationTime");
                series.add(new SeriesServiceData(info.getCalendar().getTime(), operationCount, duration, maxInvocationTime, minInvocationTime));
            }
            SeriesService seriesService = new SeriesService(series);
            this.seriesResponseSpec.setSr((SeriesResponse)seriesService);
        }
        catch (Throwable e) {
            logger.error("Error creating series for service accounting: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new AccountingManagerServiceException("Error creating series for service accounting: " + e.getLocalizedMessage());
        }
    }
}

