/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.command;

import java.util.ArrayList;
import java.util.List;
import org.gcube.accounting.analytics.ResourceRecordQuery;
import org.gcube.accounting.datamodel.aggregation.AggregatedJobUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageUsageRecord;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommand;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommandGetFilterValues;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingCommandGetFilterValues
implements AccountingCommand<ArrayList<FilterValue>> {
    private static final Logger logger = LoggerFactory.getLogger(AccountingCommandGetFilterValues.class);
    private FilterValuesRequest filterValuesRequest;

    public AccountingCommandGetFilterValues(FilterValuesRequest filterValuesRequest) {
        this.filterValuesRequest = filterValuesRequest;
    }

    public ArrayList<FilterValue> execute() throws AccountingManagerServiceException {
        try {
            List values;
            logger.debug("getFilterValue(): [FilterValueRequest=" + this.filterValuesRequest + "]");
            if (this.filterValuesRequest == null || this.filterValuesRequest.getAccountingType() == null || this.filterValuesRequest.getFilterKey() == null) {
                return new ArrayList<FilterValue>();
            }
            ArrayList<FilterValue> filteValues = new ArrayList<FilterValue>();
            ResourceRecordQuery rrq = new ResourceRecordQuery();
            switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[this.filterValuesRequest.getAccountingType().ordinal()]) {
                case 1: {
                    List values2 = rrq.getPossibleValuesForKey(AggregatedJobUsageRecord.class, this.filterValuesRequest.getFilterKey().getKey());
                    return filteValues;
                }
                case 2: {
                    return filteValues;
                }
                case 3: {
                    values = rrq.getPossibleValuesForKey(AggregatedServiceUsageRecord.class, this.filterValuesRequest.getFilterKey().getKey());
                    break;
                }
                case 4: {
                    values = rrq.getPossibleValuesForKey(AggregatedStorageUsageRecord.class, this.filterValuesRequest.getFilterKey().getKey());
                    break;
                }
                case 5: {
                    return filteValues;
                }
                default: {
                    return filteValues;
                }
            }
            for (String value : values) {
                if (value == null || value.isEmpty()) continue;
                filteValues.add(new FilterValue(value));
            }
            return filteValues;
        }
        catch (Throwable e) {
            logger.error("Error in AccountingCommandGetFilterValues(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new AccountingManagerServiceException("No values available!");
        }
    }
}

