/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.gcube.portlets.admin.accountingmanager.server.AccountingClientDaemon;
import org.gcube.portlets.admin.accountingmanager.server.amservice.cache.AccountingCache;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class AccountingClientListener
implements ServletContextListener {
    private static Logger logger = LoggerFactory.getLogger(AccountingClientListener.class);
    private AccountingClientDaemon accountingClientDaemon = null;
    private Thread thread = null;
    private volatile AccountingCache accountingCache;

    public void contextInitialized(ServletContextEvent sce) {
        logger.debug("Initializing AccountingCache");
        this.accountingCache = null;
        try {
            this.accountingCache = new AccountingCache();
        }
        catch (ServiceException e) {
            logger.error("Error initializing AccountingCache: " + e.getLocalizedMessage(), (Throwable)e);
        }
        sce.getServletContext().setAttribute("ACCOUNTING_CACHE", (Object)this.accountingCache);
        logger.debug("AccountingCache value saved in context.");
        this.accountingClientDaemon = new AccountingClientDaemon(sce, this.accountingCache);
        this.thread = new Thread((Runnable)this.accountingClientDaemon);
        logger.debug("Starting AccountingClientDaemon: " + this.thread);
        this.thread.start();
        logger.info("AccountingClientDaemon process successfully started.");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        logger.debug("Stopping AccountingClientDaemon: " + this.thread);
        if (this.thread != null) {
            this.accountingClientDaemon.terminate();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.debug("AccountingClientDaemon successfully stopped.");
        }
        logger.debug("Clear AccountingCache");
        try {
            this.accountingCache.finalize();
            logger.debug("AccountingCache finelized");
        }
        catch (Throwable e) {
            logger.error("Error in finalize AccountingCache: " + e.getLocalizedMessage(), e);
        }
        ServletContext sc = sce.getServletContext();
        sc.removeAttribute("ACCOUNTING_CACHE");
        logger.info("AccountingCache value deleted from context.");
    }
}

