/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.export.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import org.gcube.portlets.admin.accountingmanager.server.export.model.AccountingDataModel;
import org.gcube.portlets.admin.accountingmanager.server.export.model.AccountingDataRow;
import org.gcube.portlets.admin.accountingmanager.server.export.model.AccountingModelBuilder;
import org.gcube.portlets.admin.accountingmanager.server.state.AccountingStateData;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesService;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceDataTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceTop;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingModel4Service
extends AccountingModelBuilder {
    protected static Logger logger = LoggerFactory.getLogger(AccountingModel4Service.class);
    private AccountingStateData accountingStateData;

    public AccountingModel4Service(AccountingStateData accountingStateData) {
        this.accountingStateData = accountingStateData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buildOpEx() throws ServiceException {
        ArrayList<String> header;
        SeriesRequest seriesRequest = this.accountingStateData.getSeriesRequest();
        if (seriesRequest == null) {
            logger.error("Error series request is null");
            throw new ServiceException("Error series request is null");
        }
        String startDate = "";
        try {
            startDate = this.sdfFile.format(this.sdf.parse(seriesRequest.getAccountingPeriod().getStartDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String endDate = "";
        try {
            endDate = this.sdfFile.format(this.sdf.parse(seriesRequest.getAccountingPeriod().getEndDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String periodType = seriesRequest.getAccountingPeriod().getPeriod().getLabel();
        SeriesResponse seriesResponse = this.accountingStateData.getSeriesResponse();
        if (seriesResponse == null) {
            logger.error("Error series response is null");
            throw new ServiceException("Error series response is null");
        }
        String fileName = "Untitled";
        ArrayList<AccountingDataRow> rows = new ArrayList<AccountingDataRow>();
        if (!(seriesResponse instanceof SeriesService)) {
            logger.error("Service not support this serie response: " + seriesResponse);
            throw new ServiceException("Service not support this serie response: " + seriesResponse);
        }
        SeriesService seriesService = (SeriesService)seriesResponse;
        SeriesServiceDefinition definition = seriesService.getSerieServiceDefinition();
        if (definition instanceof SeriesServiceBasic) {
            SeriesServiceBasic seriesServiceBasic = (SeriesServiceBasic)definition;
            fileName = "Service_" + periodType + "_" + startDate + "_" + endDate;
            header = new ArrayList<String>(Arrays.asList("Date", "Operation Count", "Duration", "Max Invocation", "Min Invocation"));
            ArrayList listData = seriesServiceBasic.getSeries();
            for (SeriesServiceData seriesData : listData) {
                ArrayList<String> data = new ArrayList<String>();
                data.add(this.sdfCSVDate.format(seriesData.getDate()));
                data.add(String.valueOf(seriesData.getOperationCount()));
                data.add(String.valueOf(seriesData.getDuration()));
                data.add(String.valueOf(seriesData.getMaxInvocationTime()));
                data.add(String.valueOf(seriesData.getMinInvocationTime()));
                AccountingDataRow csvDataRow = new AccountingDataRow(data);
                rows.add(csvDataRow);
            }
        } else {
            if (!(definition instanceof SeriesServiceTop)) {
                logger.error("Unsupported Serie Definition for Service: " + definition);
                throw new ServiceException("Unsupported Serie Definition for Service: " + definition);
            }
            SeriesServiceTop seriesServiceTop = (SeriesServiceTop)definition;
            fileName = "ServiceTop_" + periodType + "_" + startDate + "_" + endDate;
            header = new ArrayList<String>(Arrays.asList("Value", "Date", "Operation Count", "Duration", "Max Invocation", "Min Invocation"));
            ArrayList listDataTop = seriesServiceTop.getSeriesServiceDataTopList();
            for (SeriesServiceDataTop seriesDataTop : listDataTop) {
                FilterValue filterValue = seriesDataTop.getFilterValue();
                ArrayList listData = seriesDataTop.getSeries();
                for (SeriesServiceData seriesData : listData) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(filterValue.getValue());
                    data.add(this.sdfCSVDate.format(seriesData.getDate()));
                    data.add(String.valueOf(seriesData.getOperationCount()));
                    data.add(String.valueOf(seriesData.getDuration()));
                    data.add(String.valueOf(seriesData.getMaxInvocationTime()));
                    data.add(String.valueOf(seriesData.getMinInvocationTime()));
                    AccountingDataRow csvDataRow = new AccountingDataRow(data);
                    rows.add(csvDataRow);
                }
            }
        }
        AccountingDataModel invocation = new AccountingDataModel(fileName, header, rows);
        this.accountingModelSpec.setOp(invocation);
    }
}

