/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.SortedMap;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesStorage;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageDataTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageTop;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesResponse4StorageTop
extends SeriesResponseBuilder {
    protected static Logger logger = LoggerFactory.getLogger(SeriesResponse4StorageTop.class);
    private SortedMap<NumberedFilter, SortedMap<Calendar, Info>> topSM;

    public SeriesResponse4StorageTop(SortedMap<NumberedFilter, SortedMap<Calendar, Info>> topSM) {
        this.topSM = topSM;
    }

    public void buildSeriesResponse() throws AccountingManagerServiceException {
        try {
            if (this.topSM == null || this.topSM.isEmpty()) {
                logger.error("Error creating series for storage accounting: No data available!");
                throw new AccountingManagerServiceException("No data available!");
            }
            ArrayList<SeriesStorageDataTop> seriesStorageDataTopList = new ArrayList<SeriesStorageDataTop>();
            for (NumberedFilter topValue : this.topSM.keySet()) {
                ArrayList<SeriesStorageData> series = new ArrayList<SeriesStorageData>();
                SortedMap infos = (SortedMap)this.topSM.get(topValue);
                for (Info info : infos.values()) {
                    JSONObject jso = info.getValue();
                    Long dataVolume = jso.getLong("dataVolume");
                    Long operationCount = jso.getLong("operationCount");
                    series.add(new SeriesStorageData(info.getCalendar().getTime(), dataVolume, operationCount));
                }
                SeriesStorageDataTop seriesStorageDataTop = new SeriesStorageDataTop(new FilterValue(topValue.getValue()), series);
                seriesStorageDataTopList.add(seriesStorageDataTop);
            }
            SeriesStorageTop seriesStorageTop = new SeriesStorageTop(seriesStorageDataTopList);
            SeriesStorage seriesStorage = new SeriesStorage((SeriesStorageDefinition)seriesStorageTop);
            this.seriesResponseSpec.setSr((SeriesResponse)seriesStorage);
        }
        catch (Throwable e) {
            logger.error("Error creating series for storage accounting top chart: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new AccountingManagerServiceException("Error creating series for storage accounting basic chart: " + e.getLocalizedMessage());
        }
    }
}

