/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.filters;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.ParseErrorEvent;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.DateField;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.form.Validator;
import com.sencha.gxt.widget.core.client.form.validator.EmptyValidator;
import java.util.Collection;
import java.util.Date;
import org.gcube.portlets.admin.accountingmanager.client.event.AccountingPeriodEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.AccountingPeriodRequestEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.StateChangeEvent;
import org.gcube.portlets.admin.accountingmanager.client.filters.AccountingPeriodPanel;
import org.gcube.portlets.admin.accountingmanager.client.properties.AccountingPeriodModePropertiesCombo;
import org.gcube.portlets.admin.accountingmanager.client.utils.UtilsGXT3;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriod;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriodMode;

public class AccountingPeriodPanel
extends SimpleContainer {
    private DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.YEAR_MONTH_DAY);
    private DateTimeFormat dtfYear = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.YEAR);
    private DateTimeFormat dtfShort = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_SHORT);
    private EventBus eventBus;
    private DateField startDate;
    private DateField endDate;
    private ListStore<AccountingPeriodMode> storeCombo;
    private ComboBox<AccountingPeriodMode> comboPeriodMode;

    public AccountingPeriodPanel(EventBus eventBus) {
        Log.debug((String)"AccountingPeriodPanel");
        this.eventBus = eventBus;
        this.init();
        this.create();
        this.bindToEvents();
    }

    private void init() {
    }

    private void create() {
        AccountingPeriodModePropertiesCombo props = (AccountingPeriodModePropertiesCombo)GWT.create(AccountingPeriodModePropertiesCombo.class);
        this.storeCombo = new ListStore(props.id());
        this.storeCombo.addAll((Collection)AccountingPeriodMode.asList());
        this.comboPeriodMode = new ComboBox(this.storeCombo, props.label());
        this.comboPeriodMode.setMinListWidth(250);
        this.comboPeriodMode.setEditable(false);
        this.comboPeriodMode.setTypeAhead(false);
        this.comboPeriodMode.setAllowBlank(false);
        this.comboPeriodMode.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.comboPeriodMode.setValue((Object)AccountingPeriodMode.DAILY);
        this.addHandlersForComboPeriodMode(props.label());
        Log.debug((String)"ComboPeriodMode created");
        FieldLabel periodModeLabel = new FieldLabel((IsWidget)this.comboPeriodMode, "Aggregation");
        this.startDate = new DateField();
        this.startDate.addValidator((Validator)new EmptyValidator());
        this.startDate.addParseErrorHandler((ParseErrorEvent.ParseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.startDate.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        FieldLabel startDateLabel = new FieldLabel((IsWidget)this.startDate, "Start Date");
        this.endDate = new DateField();
        this.endDate.addValidator((Validator)new EmptyValidator());
        this.endDate.addParseErrorHandler((ParseErrorEvent.ParseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.endDate.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        FieldLabel endDateLabel = new FieldLabel((IsWidget)this.endDate, "End Date");
        VerticalLayoutContainer vlc = new VerticalLayoutContainer();
        vlc.add((IsWidget)periodModeLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)startDateLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)endDateLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        FieldSet fieldSet = new FieldSet();
        fieldSet.setHeadingHtml("<b>Temporal Constraint</b>");
        fieldSet.setCollapsible(false);
        fieldSet.add((Widget)vlc);
        this.add((Widget)fieldSet, new MarginData(0));
    }

    private void bindToEvents() {
        this.eventBus.addHandler(StateChangeEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(AccountingPeriodRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void manageAccountingPeriodRequestEvent(AccountingPeriodRequestEvent event) {
        AccountingPeriod accountingPeriod = this.getAccountingPeriod();
        AccountingPeriodEvent accountingPeriodEvent = new AccountingPeriodEvent(accountingPeriod);
        this.eventBus.fireEvent((GwtEvent)accountingPeriodEvent);
    }

    private void addHandlersForComboPeriodMode(LabelProvider<AccountingPeriodMode> labelProvider) {
        this.comboPeriodMode.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateTimeInterval(AccountingPeriodMode accountingPeriodMode) {
        if (accountingPeriodMode == null) {
            this.startDate.disable();
            this.endDate.disable();
            this.startDate.setValue((Object)new Date());
            this.endDate.setValue((Object)new Date());
        }
        switch (8.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingPeriodMode[accountingPeriodMode.ordinal()]) {
            case 2: 
            case 3: {
                this.startDate.disable();
                this.endDate.disable();
                this.startDate.setValue((Object)new Date());
                this.endDate.setValue((Object)new Date());
                break;
            }
            case 1: {
                Date lastMonth = new Date();
                CalendarUtil.addMonthsToDate((Date)lastMonth, (int)-1);
                this.startDate.enable();
                this.endDate.enable();
                this.startDate.setValue((Object)lastMonth);
                this.endDate.setValue((Object)new Date());
                break;
            }
            case 5: {
                this.startDate.enable();
                this.endDate.enable();
                Date lastYear = new Date();
                CalendarUtil.setToFirstDayOfMonth((Date)lastYear);
                CalendarUtil.addMonthsToDate((Date)lastYear, (int)-12);
                this.startDate.setValue((Object)lastYear);
                Date currentMonth = new Date();
                CalendarUtil.setToFirstDayOfMonth((Date)currentMonth);
                CalendarUtil.addMonthsToDate((Date)currentMonth, (int)1);
                CalendarUtil.addDaysToDate((Date)currentMonth, (int)-1);
                this.endDate.setValue((Object)currentMonth);
                break;
            }
            case 4: {
                this.startDate.enable();
                this.endDate.enable();
                Date currentYear = new Date();
                String currentYearS = this.dtfYear.format(currentYear);
                int yearLast3 = Integer.parseInt(currentYearS) - 3;
                Date last3Year = this.dtfShort.parse(yearLast3 + "-01-01");
                this.startDate.setValue((Object)last3Year);
                Date endOfYear = this.dtfShort.parse(currentYearS + "-12-31");
                this.endDate.setValue((Object)endOfYear);
                break;
            }
            default: {
                this.startDate.disable();
                this.endDate.disable();
                this.startDate.setValue((Object)new Date());
                this.endDate.setValue((Object)new Date());
            }
        }
    }

    private void doStateChangeCommand(StateChangeEvent event) {
        if (event.getStateChangeType() == null) {
            return;
        }
        switch (8.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$type$StateChangeType[event.getStateChangeType().ordinal()]) {
            case 1: {
                this.onRestoreStateChange(event);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void onRestoreStateChange(StateChangeEvent event) {
        if (event.getAccountingStateData() != null && event.getAccountingStateData().getSeriesRequest() != null && event.getAccountingStateData().getSeriesRequest().getAccountingPeriod() != null) {
            AccountingPeriod accountingPeriod = event.getAccountingStateData().getSeriesRequest().getAccountingPeriod();
            this.startDate.setValue((Object)this.dtf.parse(accountingPeriod.getStartDate()));
            this.endDate.setValue((Object)this.dtf.parse(accountingPeriod.getEndDate()));
            this.comboPeriodMode.setValue((Object)accountingPeriod.getPeriod());
        } else {
            this.startDate.reset();
            this.endDate.reset();
            this.comboPeriodMode.reset();
            this.comboPeriodMode.setValue((Object)AccountingPeriodMode.DAILY);
        }
        this.forceLayout();
    }

    public AccountingPeriod getAccountingPeriod() {
        try {
            if (this.startDate.validate() && this.endDate.validate()) {
                if (((Date)this.startDate.getCurrentValue()).compareTo(new Date()) <= 0) {
                    if (((Date)this.endDate.getCurrentValue()).compareTo(new Date()) <= 0 || ((AccountingPeriodMode)this.comboPeriodMode.getCurrentValue()).compareTo((Enum)AccountingPeriodMode.MONTHLY) == 0 || ((AccountingPeriodMode)this.comboPeriodMode.getCurrentValue()).compareTo((Enum)AccountingPeriodMode.YEARLY) == 0) {
                        Date endD;
                        Date startD = (Date)this.startDate.getCurrentValue();
                        if (startD.compareTo(endD = (Date)this.endDate.getCurrentValue()) <= 0) {
                            if (this.comboPeriodMode.validate() && this.comboPeriodMode.getCurrentValue() != null) {
                                switch (8.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingPeriodMode[((AccountingPeriodMode)this.comboPeriodMode.getCurrentValue()).ordinal()]) {
                                    case 2: 
                                    case 3: {
                                        break;
                                    }
                                    case 1: {
                                        Date maximumDistantDay = new Date();
                                        CalendarUtil.addMonthsToDate((Date)maximumDistantDay, (int)-1);
                                        CalendarUtil.addDaysToDate((Date)maximumDistantDay, (int)-1);
                                        if (maximumDistantDay.compareTo(startD) >= 0) {
                                            UtilsGXT3.alert((String)"Attention", (String)"Invalid Start Date (Daily: the max interval should the last month)!");
                                            return null;
                                        }
                                        if (maximumDistantDay.compareTo(endD) < 0) break;
                                        UtilsGXT3.alert((String)"Attention", (String)"Invalid End Date (Daily: the max interval should the last month)!");
                                        return null;
                                    }
                                    case 5: {
                                        Date maximumDistantMonth = new Date();
                                        CalendarUtil.setToFirstDayOfMonth((Date)maximumDistantMonth);
                                        CalendarUtil.addMonthsToDate((Date)maximumDistantMonth, (int)-60);
                                        CalendarUtil.addDaysToDate((Date)maximumDistantMonth, (int)-1);
                                        if (maximumDistantMonth.compareTo(startD) >= 0) {
                                            UtilsGXT3.alert((String)"Attention", (String)"Invalid Start Date (Monthly: the max interval should in the last 5 years)!");
                                            return null;
                                        }
                                        Date maximumDistantMonthFuture = new Date();
                                        CalendarUtil.setToFirstDayOfMonth((Date)maximumDistantMonthFuture);
                                        CalendarUtil.addMonthsToDate((Date)maximumDistantMonthFuture, (int)1);
                                        Log.debug((String)("[EndDate=" + endD + ", maximumDistant=" + maximumDistantMonthFuture + ""));
                                        if (maximumDistantMonthFuture.compareTo(endD) >= 0) break;
                                        UtilsGXT3.alert((String)"Attention", (String)"Invalid End Date (Monthly: the max interval should in the last 5 years)!");
                                        return null;
                                    }
                                    case 4: {
                                        break;
                                    }
                                }
                                AccountingPeriod accountingPeriod = new AccountingPeriod(this.dtf.format(startD), this.dtf.format(endD), (AccountingPeriodMode)this.comboPeriodMode.getCurrentValue());
                                return accountingPeriod;
                            }
                            UtilsGXT3.alert((String)"Attention", (String)"Select a valid aggregation mode!");
                            return null;
                        }
                        UtilsGXT3.alert((String)"Attention", (String)"The start date must be less than or equal to the end date!");
                        return null;
                    }
                    String endD = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_SHORT).format(new Date());
                    UtilsGXT3.alert((String)"Attention", (String)("The end date must be " + endD + " or earlier!"));
                    return null;
                }
                String startD = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_SHORT).format(new Date());
                UtilsGXT3.alert((String)"Attention", (String)("The start date must be " + startD + " or earlier!"));
                return null;
            }
            return null;
        }
        catch (Throwable e) {
            Log.error((String)e.getLocalizedMessage());
            e.printStackTrace();
            UtilsGXT3.alert((String)"Attention", (String)e.getLocalizedMessage());
            return null;
        }
    }

    static /* synthetic */ ComboBox access$000(AccountingPeriodPanel x0) {
        return x0.comboPeriodMode;
    }

    static /* synthetic */ DateField access$100(AccountingPeriodPanel x0) {
        return x0.startDate;
    }

    static /* synthetic */ DateField access$200(AccountingPeriodPanel x0) {
        return x0.endDate;
    }

    static /* synthetic */ void access$300(AccountingPeriodPanel x0, StateChangeEvent x1) {
        x0.doStateChangeCommand(x1);
    }

    static /* synthetic */ void access$400(AccountingPeriodPanel x0, AccountingPeriodRequestEvent x1) {
        x0.manageAccountingPeriodRequestEvent(x1);
    }

    static /* synthetic */ void access$500(AccountingPeriodPanel x0, AccountingPeriodMode x1) {
        x0.updateTimeInterval(x1);
    }
}

