/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.filters;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell;
import com.sencha.gxt.core.client.Style;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.dnd.core.client.DND;
import com.sencha.gxt.dnd.core.client.DndDragStartEvent;
import com.sencha.gxt.dnd.core.client.GridDragSource;
import com.sencha.gxt.dnd.core.client.GridDropTarget;
import com.sencha.gxt.widget.core.client.button.ButtonBar;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.BeforeStartEditEvent;
import com.sencha.gxt.widget.core.client.event.CancelEditEvent;
import com.sencha.gxt.widget.core.client.event.CompleteEditEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.form.IntegerSpinnerField;
import com.sencha.gxt.widget.core.client.form.IsField;
import com.sencha.gxt.widget.core.client.form.StringComboBox;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.GridSelectionModel;
import com.sencha.gxt.widget.core.client.grid.editing.GridRowEditing;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.portlets.admin.accountingmanager.client.event.AccountingPeriodEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.AccountingPeriodRequestEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.StateChangeEvent;
import org.gcube.portlets.admin.accountingmanager.client.filters.ActiveFiltersPanel;
import org.gcube.portlets.admin.accountingmanager.client.properties.AccountingFilterProperties;
import org.gcube.portlets.admin.accountingmanager.client.resource.AccountingManagerResources;
import org.gcube.portlets.admin.accountingmanager.client.rpc.AccountingManagerServiceAsync;
import org.gcube.portlets.admin.accountingmanager.client.state.AccountingStateData;
import org.gcube.portlets.admin.accountingmanager.client.utils.UtilsGXT3;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilter;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.ChartType;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterKey;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesRequest;

public class ActiveFiltersPanel
extends SimpleContainer {
    private static final int TOP_NUMBER_DEFAULT = 5;
    private static final int TOP_NUMBER_MAX = 10;
    private static final int TOP_NUMBER_MIN = 1;
    private EventBus eventBus;
    private Grid<AccountingFilter> grid;
    private ListStore<AccountingFilter> store;
    private boolean addStatus;
    private AccountingStateData accountingStateData;
    private ListStore<FilterKey> storeComboFilterKey;
    private ComboBox<FilterKey> comboFilterKey;
    private ListStore<String> storeComboFilterValue;
    private StringComboBox comboFilterValue;
    private GridRowEditing<AccountingFilter> editing;
    private TextButton addButton;
    private int seq;
    private ListStore<ChartType> storeComboChartType;
    private ComboBox<ChartType> comboChartType;
    private ListStore<FilterKey> storeComboTopFilterKey;
    private ComboBox<FilterKey> comboTopFilterKey;
    private FieldLabel comboTopFilterKeyLabel;
    private ToolBar toolBar;
    private IntegerSpinnerField topNumber;
    private FieldLabel topNumberLabel;
    private FilterKey filterKey;
    private boolean cancelValue;

    public ActiveFiltersPanel(EventBus eventBus) {
        Log.debug((String)"ActiveFiltersPanel");
        this.eventBus = eventBus;
        this.init();
        this.create();
        this.bindToEvents();
    }

    private void init() {
    }

    private void create() {
        AccountingFilterProperties props = (AccountingFilterProperties)GWT.create(AccountingFilterProperties.class);
        ColumnConfig keyColumn = new ColumnConfig(props.filterKey(), 130, "Key");
        keyColumn.setMenuDisabled(true);
        keyColumn.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ColumnConfig valueColumn = new ColumnConfig(props.filterValue(), 130, "Value");
        valueColumn.setMenuDisabled(true);
        valueColumn.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<ColumnConfig> l = new ArrayList<ColumnConfig>();
        l.add(keyColumn);
        l.add(valueColumn);
        ColumnModel columns = new ColumnModel(l);
        this.store = new ListStore(props.id());
        GridSelectionModel sm = new GridSelectionModel();
        sm.setSelectionMode(Style.SelectionMode.SINGLE);
        this.grid = new Grid(this.store, columns);
        this.grid.setSelectionModel(sm);
        this.grid.getView().setStripeRows(true);
        this.grid.getView().setColumnLines(true);
        this.grid.getView().setAutoFill(true);
        this.grid.setBorders(false);
        this.grid.setColumnReordering(false);
        this.grid.getView().setAutoExpandColumn(valueColumn);
        this.grid.getView().setSortingEnabled(false);
        GridDragSource ds = new GridDragSource(this.grid);
        ds.addDragStartHandler((DndDragStartEvent.DndDragStartHandler)new /* Unavailable Anonymous Inner Class!! */);
        GridDropTarget dt = new GridDropTarget(this.grid);
        dt.setFeedback(DND.Feedback.BOTH);
        dt.setAllowSelfAsSource(true);
        FilterKeyPropertiesCombo filterKeyPropertiesCombo = (FilterKeyPropertiesCombo)GWT.create(FilterKeyPropertiesCombo.class);
        this.storeComboFilterKey = new ListStore(filterKeyPropertiesCombo.id());
        this.comboFilterKey = new ComboBox(this.storeComboFilterKey, filterKeyPropertiesCombo.key());
        this.comboFilterKey.setClearValueOnParseError(false);
        this.comboFilterKey.setEditable(false);
        this.comboFilterKey.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.addHandlersForComboFilterKey(filterKeyPropertiesCombo.key());
        this.storeComboFilterValue = new ListStore((ModelKeyProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.comboFilterValue = new StringComboBox();
        this.comboFilterValue.setStore(this.storeComboFilterValue);
        this.comboFilterValue.setClearValueOnParseError(false);
        this.comboFilterValue.setEditable(true);
        this.comboFilterValue.setForceSelection(false);
        this.comboFilterValue.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.editing = new GridRowEditing(this.grid);
        this.editing.addEditor(keyColumn, (IsField)this.comboFilterKey);
        this.editing.addEditor(valueColumn, (IsField)this.comboFilterValue);
        this.addButton = new TextButton("Add Filter");
        this.addButton.setIcon(AccountingManagerResources.INSTANCE.accountingFilter24());
        this.addButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.addButton.setToolTip("Add Filter");
        this.addButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        TextButton deleteBtn = new TextButton("Delete");
        deleteBtn.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        ButtonBar buttonBar = this.editing.getButtonBar();
        buttonBar.add((Widget)deleteBtn);
        this.editing.addBeforeStartEditHandler((BeforeStartEditEvent.BeforeStartEditHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.editing.addCancelEditHandler((CancelEditEvent.CancelEditHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.editing.addCompleteEditHandler((CompleteEditEvent.CompleteEditHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.toolBar = new ToolBar();
        this.toolBar.add((IsWidget)this.addButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        this.storeComboChartType = new ListStore((ModelKeyProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.storeComboChartType.addAll((Collection)ChartType.asList());
        11 comboChartTypeLabelProvider = new /* Unavailable Anonymous Inner Class!! */;
        this.comboChartType = new ComboBox(this.storeComboChartType, (LabelProvider)comboChartTypeLabelProvider);
        this.comboChartType.setClearValueOnParseError(false);
        this.comboChartType.setEditable(false);
        this.comboChartType.setForceSelection(true);
        this.comboChartType.setValue((Object)ChartType.Basic);
        this.comboChartType.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.addHandlersForComboChartType((LabelProvider)comboChartTypeLabelProvider);
        FieldLabel comboChartTypeLabel = new FieldLabel((IsWidget)this.comboChartType, "Chart");
        this.storeComboTopFilterKey = new ListStore(filterKeyPropertiesCombo.id());
        this.comboTopFilterKey = new ComboBox(this.storeComboTopFilterKey, filterKeyPropertiesCombo.key());
        this.comboTopFilterKey.setClearValueOnParseError(false);
        this.comboTopFilterKey.setEditable(false);
        this.comboTopFilterKey.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.addHandlersForComboTopFilterKey(filterKeyPropertiesCombo.key());
        this.comboTopFilterKeyLabel = new FieldLabel((IsWidget)this.comboTopFilterKey, "Key");
        this.topNumber = new IntegerSpinnerField();
        this.topNumber.setMaxValue((Number)10);
        this.topNumber.setMinValue((Number)1);
        this.topNumber.setAllowNegative(false);
        this.topNumber.setAllowBlank(false);
        this.topNumber.setValue((Object)5);
        this.topNumber.setEditable(false);
        this.topNumberLabel = new FieldLabel((IsWidget)this.topNumber, "Number");
        VerticalLayoutContainer vlc = new VerticalLayoutContainer();
        vlc.add((IsWidget)comboChartTypeLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.comboTopFilterKeyLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.topNumberLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.grid, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        FieldSet fieldSet = new FieldSet();
        fieldSet.setHeadingHtml("<b>Active Filters</b>");
        fieldSet.setCollapsible(false);
        fieldSet.add((Widget)vlc);
        this.add((Widget)fieldSet, new MarginData(0));
        this.comboTopFilterKeyLabel.setVisible(false);
        this.topNumberLabel.setVisible(false);
    }

    private void bindToEvents() {
        this.eventBus.addHandler(StateChangeEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(AccountingPeriodEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doStateChangeCommand(StateChangeEvent event) {
        if (event.getStateChangeType() == null) {
            return;
        }
        switch (18.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$type$StateChangeType[event.getStateChangeType().ordinal()]) {
            case 1: {
                this.onRestoreStateChange(event);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void onRestoreStateChange(StateChangeEvent event) {
        if (event.getAccountingStateData() != null) {
            this.accountingStateData = event.getAccountingStateData();
            this.changeActiveFilters();
        } else {
            this.accountingStateData = null;
            this.seq = 0;
        }
        Log.debug((String)("Set seq to: " + this.seq));
        this.forceLayout();
    }

    private void changeActiveFilters() {
        this.storeComboFilterKey.clear();
        this.storeComboFilterKey.addAll((Collection)this.accountingStateData.getAvailableFilterKeys());
        this.storeComboFilterKey.commitChanges();
        this.storeComboTopFilterKey.clear();
        this.storeComboTopFilterKey.addAll((Collection)this.accountingStateData.getAvailableFilterKeys());
        this.storeComboTopFilterKey.commitChanges();
        ChartType chartType = this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition().getChartType();
        switch (18.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$ChartType[chartType.ordinal()]) {
            case 1: {
                this.changeActiveFiltersForBasic();
                break;
            }
            case 2: {
                this.changeActiveFiltersForTop();
                break;
            }
            default: {
                this.changeActiveFiltersForBasic();
            }
        }
    }

    private void changeActiveFiltersForBasic() {
        if (this.accountingStateData.getSeriesRequest() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() instanceof AccountingFilterBasic) {
            AccountingFilterBasic accountingFilterBasic = (AccountingFilterBasic)this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition();
            if (accountingFilterBasic.getFilters() != null) {
                ArrayList filters = accountingFilterBasic.getFilters();
                this.store.clear();
                this.store.addAll((Collection)filters);
                this.seq = 0;
                for (AccountingFilter filter : filters) {
                    if (filter.getId() <= this.seq) continue;
                    this.seq = filter.getId();
                }
                this.store.commitChanges();
            } else {
                this.store.clear();
                this.store.commitChanges();
                this.seq = 0;
            }
        } else {
            this.store.clear();
            this.store.commitChanges();
            this.seq = 0;
        }
        this.comboChartType.setValue((Object)ChartType.Basic);
        this.comboTopFilterKey.reset();
        this.comboTopFilterKeyLabel.setVisible(false);
        this.topNumber.reset();
        this.topNumberLabel.setVisible(false);
        this.forceLayout();
    }

    private void changeActiveFiltersForTop() {
        if (this.accountingStateData.getSeriesRequest() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() instanceof AccountingFilterTop) {
            AccountingFilterTop accountingFilterTop = (AccountingFilterTop)this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition();
            if (accountingFilterTop.getFilterKey() != null) {
                this.comboTopFilterKey.setValue((Object)accountingFilterTop.getFilterKey());
                this.topNumber.setValue((Object)accountingFilterTop.getTopNumber());
            } else {
                this.comboTopFilterKey.reset();
                this.topNumber.reset();
                this.topNumber.setValue((Object)5);
            }
        } else {
            this.comboTopFilterKey.reset();
            this.topNumber.reset();
            this.topNumber.setValue((Object)5);
        }
        this.store.clear();
        this.store.commitChanges();
        this.seq = 0;
        this.comboChartType.setValue((Object)ChartType.Top);
        this.comboTopFilterKeyLabel.setVisible(true);
        this.topNumberLabel.setVisible(true);
        this.forceLayout();
    }

    public AccountingFilterDefinition getActiveFilters() {
        try {
            ChartType chartType = (ChartType)this.comboChartType.getCurrentValue();
            switch (18.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$ChartType[chartType.ordinal()]) {
                case 1: {
                    return this.getActiveFiltersForBasic();
                }
                case 2: {
                    return this.getActiveFiltersForTop();
                }
            }
            return null;
        }
        catch (Throwable e) {
            Log.error((String)e.getLocalizedMessage());
            e.printStackTrace();
            UtilsGXT3.alert((String)"Attention", (String)e.getLocalizedMessage());
            return null;
        }
    }

    private AccountingFilterDefinition getActiveFiltersForBasic() {
        if (this.store == null || this.store.size() <= 0) {
            return new AccountingFilterBasic();
        }
        List filtersActives = this.store.getAll();
        ArrayList<AccountingFilter> filtersReady = new ArrayList<AccountingFilter>();
        for (AccountingFilter filter : filtersActives) {
            if (filter.getFilterValue() == null || filter.getFilterValue().isEmpty()) continue;
            filtersReady.add(filter);
        }
        if (filtersReady.size() > 0) {
            return new AccountingFilterBasic(filtersReady);
        }
        return new AccountingFilterBasic();
    }

    private AccountingFilterDefinition getActiveFiltersForTop() {
        FilterKey filterKey = (FilterKey)this.comboTopFilterKey.getCurrentValue();
        if (filterKey == null) {
            return new AccountingFilterTop();
        }
        Integer topN = (Integer)this.topNumber.getCurrentValue();
        if (this.store == null || this.store.size() <= 0) {
            return new AccountingFilterTop(filterKey, null, topN);
        }
        List filtersActives = this.store.getAll();
        ArrayList<AccountingFilter> filtersReady = new ArrayList<AccountingFilter>();
        for (AccountingFilter filter : filtersActives) {
            if (filter.getFilterValue() == null || filter.getFilterValue().isEmpty()) continue;
            filtersReady.add(filter);
        }
        if (filtersReady.size() > 0) {
            return new AccountingFilterTop(filterKey, filtersReady, topN);
        }
        return new AccountingFilterTop(filterKey, null, topN);
    }

    private void addNewFilter(SelectEvent event) {
        List filtersSet = this.store.getAll();
        FilterKey fk = null;
        if (this.accountingStateData == null || this.accountingStateData.getAvailableFilterKeys() == null || this.accountingStateData.getAvailableFilterKeys().size() < 0) {
            UtilsGXT3.info((String)"No key available", (String)"No key available");
        } else {
            ArrayList remainingFilterKeys = new ArrayList(this.accountingStateData.getAvailableFilterKeys());
            ArrayList<Object> removableFilterKeys = new ArrayList<Object>();
            for (AccountingFilter filterSet : filtersSet) {
                removableFilterKeys.add(filterSet.getFilterKey());
            }
            if (this.comboChartType.getCurrentValue() != null && ((ChartType)this.comboChartType.getCurrentValue()).compareTo((Enum)ChartType.Top) == 0 && this.comboTopFilterKey.getCurrentValue() != null) {
                removableFilterKeys.add(this.comboTopFilterKey.getCurrentValue());
            }
            remainingFilterKeys.removeAll(removableFilterKeys);
            if (remainingFilterKeys.size() > 0) {
                fk = (FilterKey)remainingFilterKeys.get(0);
                ++this.seq;
                AccountingFilter newAccountingFilter = new AccountingFilter(this.seq, fk, "");
                Log.debug((String)("newAccountingFilter: " + newAccountingFilter));
                this.editing.cancelEditing();
                this.addStatus = true;
                this.editing.getCancelButton().setVisible(false);
                this.store.add((Object)newAccountingFilter);
                int row = this.store.indexOf((Object)newAccountingFilter);
                this.storeComboFilterKey.clear();
                this.storeComboFilterKey.addAll(remainingFilterKeys);
                this.storeComboFilterKey.commitChanges();
                this.editing.startEditing(new Grid.GridCell(row, 0));
            } else {
                UtilsGXT3.info((String)"No key available", (String)"No key available");
            }
        }
    }

    private void retrieveFilterValuesByKey(FilterKey filterKey, boolean cancelValue) {
        this.filterKey = filterKey;
        this.cancelValue = cancelValue;
        AccountingPeriodRequestEvent event = new AccountingPeriodRequestEvent();
        this.eventBus.fireEvent((GwtEvent)event);
    }

    private void manageAccountingPeriodEvent(AccountingPeriodEvent event) {
        if (event == null || event.getAccountingPeriod() == null) {
            Log.debug((String)"AccountingPeriod not valid");
            return;
        }
        FilterValuesRequest requestFilterValue = new FilterValuesRequest(this.filterKey, this.accountingStateData.getAccountingType(), event.getAccountingPeriod());
        AccountingManagerServiceAsync.INSTANCE.getFilterValues(requestFilterValue, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void editingBeforeStart(BeforeStartEditEvent<AccountingFilter> event) {
        Grid.GridCell cell = event.getEditCell();
        int rowIndex = cell.getRow();
        AccountingFilter editingFilter = (AccountingFilter)this.store.get(rowIndex);
        List filtersSet = this.store.getAll();
        ArrayList remainingFilterKeys = null;
        remainingFilterKeys = this.accountingStateData == null || this.accountingStateData.getAvailableFilterKeys() == null ? new ArrayList() : new ArrayList(this.accountingStateData.getAvailableFilterKeys());
        ArrayList<Object> setFilterKeys = new ArrayList<Object>();
        if (this.comboChartType.getCurrentValue() != null && ((ChartType)this.comboChartType.getCurrentValue()).compareTo((Enum)ChartType.Top) == 0 && this.comboTopFilterKey.getCurrentValue() != null) {
            setFilterKeys.add(this.comboTopFilterKey.getCurrentValue());
        }
        for (AccountingFilter filterSet : filtersSet) {
            if (filterSet.getFilterKey().getKey().compareTo(editingFilter.getFilterKey().getKey()) == 0) continue;
            setFilterKeys.add(filterSet.getFilterKey());
        }
        remainingFilterKeys.removeAll(setFilterKeys);
        this.storeComboFilterKey.clear();
        this.storeComboFilterKey.addAll(remainingFilterKeys);
        this.storeComboFilterKey.commitChanges();
        if (editingFilter.getFilterKey() != null) {
            this.retrieveFilterValuesByKey(editingFilter.getFilterKey(), false);
        }
        this.addButton.setEnabled(false);
    }

    private void addHandlersForComboFilterKey(LabelProvider<FilterKey> labelProvider) {
        this.comboFilterKey.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateFilterKey(FilterKey selectedFilterKey) {
        this.retrieveFilterValuesByKey(selectedFilterKey, true);
    }

    private void addHandlersForComboChartType(LabelProvider<ChartType> labelProvider) {
        this.comboChartType.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateComboChartType(ChartType chartType) {
        if (chartType == null) {
            return;
        }
        switch (18.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$ChartType[chartType.ordinal()]) {
            case 1: {
                this.comboTopFilterKey.reset();
                this.comboTopFilterKeyLabel.setVisible(false);
                this.topNumber.reset();
                this.topNumberLabel.setVisible(false);
                this.store.clear();
                this.store.commitChanges();
                this.seq = 0;
                this.forceLayout();
                break;
            }
            case 2: {
                this.comboTopFilterKey.reset();
                if (this.accountingStateData != null && this.accountingStateData.getAvailableFilterKeys() != null && this.accountingStateData.getAvailableFilterKeys().size() > 0) {
                    this.comboTopFilterKey.setValue(this.accountingStateData.getAvailableFilterKeys().get(0));
                }
                this.comboTopFilterKeyLabel.setVisible(true);
                this.topNumber.reset();
                this.topNumber.setValue((Object)5);
                this.topNumberLabel.setVisible(true);
                this.store.clear();
                this.store.commitChanges();
                this.seq = 0;
                this.forceLayout();
                break;
            }
        }
    }

    private void addHandlersForComboTopFilterKey(LabelProvider<FilterKey> labelProvider) {
        this.comboTopFilterKey.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateTopFilterKey(FilterKey selectedFilterKey) {
        this.store.clear();
        this.store.commitChanges();
        this.seq = 0;
    }

    static /* synthetic */ void access$000(ActiveFiltersPanel x0, SelectEvent x1) {
        x0.addNewFilter(x1);
    }

    static /* synthetic */ GridRowEditing access$100(ActiveFiltersPanel x0) {
        return x0.editing;
    }

    static /* synthetic */ ListStore access$200(ActiveFiltersPanel x0) {
        return x0.store;
    }

    static /* synthetic */ TextButton access$300(ActiveFiltersPanel x0) {
        return x0.addButton;
    }

    static /* synthetic */ boolean access$400(ActiveFiltersPanel x0) {
        return x0.addStatus;
    }

    static /* synthetic */ boolean access$402(ActiveFiltersPanel x0, boolean x1) {
        x0.addStatus = x1;
        return x0.addStatus;
    }

    static /* synthetic */ void access$500(ActiveFiltersPanel x0, BeforeStartEditEvent x1) {
        x0.editingBeforeStart(x1);
    }

    static /* synthetic */ void access$600(ActiveFiltersPanel x0, StateChangeEvent x1) {
        x0.doStateChangeCommand(x1);
    }

    static /* synthetic */ void access$700(ActiveFiltersPanel x0, AccountingPeriodEvent x1) {
        x0.manageAccountingPeriodEvent(x1);
    }

    static /* synthetic */ EventBus access$800(ActiveFiltersPanel x0) {
        return x0.eventBus;
    }

    static /* synthetic */ boolean access$900(ActiveFiltersPanel x0) {
        return x0.cancelValue;
    }

    static /* synthetic */ StringComboBox access$1000(ActiveFiltersPanel x0) {
        return x0.comboFilterValue;
    }

    static /* synthetic */ ListStore access$1100(ActiveFiltersPanel x0) {
        return x0.storeComboFilterValue;
    }

    static /* synthetic */ void access$1200(ActiveFiltersPanel x0, FilterKey x1) {
        x0.updateFilterKey(x1);
    }

    static /* synthetic */ void access$1300(ActiveFiltersPanel x0, ChartType x1) {
        x0.updateComboChartType(x1);
    }

    static /* synthetic */ void access$1400(ActiveFiltersPanel x0, FilterKey x1) {
        x0.updateTopFilterKey(x1);
    }
}

