/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.filters;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.core.client.dom.ScrollSupport;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.FiltersChangeEvent;
import org.gcube.portlets.admin.accountingmanager.client.filters.AccountingPeriodPanel;
import org.gcube.portlets.admin.accountingmanager.client.filters.ActiveFiltersPanel;
import org.gcube.portlets.admin.accountingmanager.client.resource.AccountingManagerResources;
import org.gcube.portlets.admin.accountingmanager.client.type.FiltersChangeType;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriod;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;

public class FiltersPanel
extends FramedPanel {
    private EventBus eventBus;
    private AccountingPeriodPanel accountPeriodPanel;
    private TextButton updateCharts;
    private ActiveFiltersPanel activeFiltersPanel;

    public FiltersPanel(EventBus eventBus) {
        Log.debug((String)"FiltersPanel");
        this.eventBus = eventBus;
        this.init();
        this.create();
    }

    protected void init() {
        this.forceLayoutOnResize = true;
        this.setBodyBorder(false);
        this.setBorders(false);
        this.setHeaderVisible(false);
    }

    protected void create() {
        this.accountPeriodPanel = new AccountingPeriodPanel(this.eventBus);
        this.activeFiltersPanel = new ActiveFiltersPanel(this.eventBus);
        this.updateCharts = new TextButton("Update Chart");
        this.updateCharts.setIcon(AccountingManagerResources.INSTANCE.accountingReload24());
        this.updateCharts.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.updateCharts.setToolTip("Update Chart");
        this.updateCharts.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        HBoxLayoutContainer hBox = new HBoxLayoutContainer();
        hBox.setPack(BoxLayoutContainer.BoxLayoutPack.START);
        hBox.add((IsWidget)this.updateCharts, new BoxLayoutContainer.BoxLayoutData(new Margins(2, 5, 2, 5)));
        VerticalLayoutContainer vlc = new VerticalLayoutContainer();
        vlc.setScrollMode(ScrollSupport.ScrollMode.AUTO);
        vlc.add((IsWidget)this.accountPeriodPanel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(4, 0, 2, 4)));
        vlc.add((IsWidget)this.activeFiltersPanel, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(4, 0, 2, 4)));
        vlc.add((IsWidget)hBox, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        this.add((Widget)vlc);
    }

    protected void updateChart() {
        AccountingPeriod accountingPeriod = this.accountPeriodPanel.getAccountingPeriod();
        AccountingFilterDefinition accountingFilterDefinition = this.activeFiltersPanel.getActiveFilters();
        if (accountingPeriod != null) {
            SeriesRequest seriesRequest = new SeriesRequest(accountingPeriod, accountingFilterDefinition);
            Log.debug((String)("UpdateChart: " + seriesRequest));
            FiltersChangeEvent filtersChangeEvent = new FiltersChangeEvent(FiltersChangeType.Update, seriesRequest);
            this.eventBus.fireEvent((GwtEvent)filtersChangeEvent);
        }
    }
}

