/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.SortedMap;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.Context;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesService;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceContext;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceDataContext;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesResponse4ServiceContext
extends SeriesResponseBuilder {
    protected static Logger logger = LoggerFactory.getLogger(SeriesResponse4ServiceContext.class);
    private Context context;
    private SortedMap<Filter, SortedMap<Calendar, Info>> contextSM;

    public SeriesResponse4ServiceContext(Context context, SortedMap<Filter, SortedMap<Calendar, Info>> contextSM) {
        this.context = context;
        this.contextSM = contextSM;
    }

    public void buildSeriesResponse() throws ServiceException {
        try {
            if (this.contextSM == null || this.contextSM.isEmpty()) {
                logger.error("Error creating series for service accounting: No data available!");
                throw new ServiceException("No data available!");
            }
            ArrayList<SeriesServiceDataContext> seriesServiceDataContextList = new ArrayList<SeriesServiceDataContext>();
            for (Filter contextValue : this.contextSM.keySet()) {
                ArrayList<SeriesServiceData> series = new ArrayList<SeriesServiceData>();
                SortedMap infos = (SortedMap)this.contextSM.get(contextValue);
                for (Info info : infos.values()) {
                    JSONObject jso = info.getValue();
                    Long duration = jso.getLong("duration");
                    Long operationCount = jso.getLong("operationCount");
                    Long maxInvocationTime = jso.getLong("maxInvocationTime");
                    Long minInvocationTime = jso.getLong("minInvocationTime");
                    series.add(new SeriesServiceData(info.getCalendar().getTime(), operationCount, duration, maxInvocationTime, minInvocationTime));
                }
                SeriesServiceDataContext seriesServiceDataContext = new SeriesServiceDataContext(contextValue.getValue(), series);
                seriesServiceDataContextList.add(seriesServiceDataContext);
            }
            SeriesServiceContext seriesServiceContext = new SeriesServiceContext(this.context, seriesServiceDataContextList);
            SeriesService seriesService = new SeriesService((SeriesServiceDefinition)seriesServiceContext);
            this.seriesResponseSpec.setSr((SeriesResponse)seriesService);
        }
        catch (Throwable e) {
            logger.error("Error creating series for service accounting context chart: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("Error creating series for service accounting context chart: " + e.getLocalizedMessage());
        }
    }
}

