/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.SortedMap;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.Context;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesStorage;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageContext;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageDataContext;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesResponse4StorageContext
extends SeriesResponseBuilder {
    protected static Logger logger = LoggerFactory.getLogger(SeriesResponse4StorageContext.class);
    private Context context;
    private SortedMap<Filter, SortedMap<Calendar, Info>> contextSM;

    public SeriesResponse4StorageContext(Context context, SortedMap<Filter, SortedMap<Calendar, Info>> contextSM) {
        this.context = context;
        this.contextSM = contextSM;
    }

    public void buildSeriesResponse() throws ServiceException {
        try {
            if (this.contextSM == null || this.contextSM.isEmpty()) {
                logger.error("Error creating series for storage accounting: No data available!");
                throw new ServiceException("No data available!");
            }
            ArrayList<SeriesStorageDataContext> seriesStorageDataContextList = new ArrayList<SeriesStorageDataContext>();
            for (Filter contextValue : this.contextSM.keySet()) {
                ArrayList<SeriesStorageData> series = new ArrayList<SeriesStorageData>();
                SortedMap infos = (SortedMap)this.contextSM.get(contextValue);
                for (Info info : infos.values()) {
                    JSONObject jso = info.getValue();
                    Long dataVolume = jso.getLong("dataVolume");
                    Long operationCount = jso.getLong("operationCount");
                    series.add(new SeriesStorageData(info.getCalendar().getTime(), dataVolume, operationCount));
                }
                SeriesStorageDataContext seriesStorageDataContext = new SeriesStorageDataContext(contextValue.getValue(), series);
                seriesStorageDataContextList.add(seriesStorageDataContext);
            }
            SeriesStorageContext seriesStorageContext = new SeriesStorageContext(this.context, seriesStorageDataContextList);
            SeriesStorage seriesStorage = new SeriesStorage((SeriesStorageDefinition)seriesStorageContext);
            this.seriesResponseSpec.setSr((SeriesResponse)seriesStorage);
        }
        catch (Throwable e) {
            logger.error("Error creating series for storage accounting context chart: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("Error creating series for storage accounting context chart: " + e.getLocalizedMessage());
        }
    }
}

