/****************************************************************************
= *  This software is part of the gCube Project.
 *  Site: http://www.gcube-system.org/
 ****************************************************************************
 * The gCube/gCore software is licensed as Free Open Source software
 * conveying to the EUPL (http://ec.europa.eu/idabc/eupl).
 * The software and documentation is provided by its authors/distributors
 * "as is" and no expressed or
 * implied warranty is given for its use, quality or fitness for a
 * particular case.
 ****************************************************************************
 * Filename: ActivationRecordVMForm.java
 ****************************************************************************
 * @author <a href="mailto:daniele.strollo@isti.cnr.it">Daniele Strollo</a>
 ***************************************************************************/

package org.gcube.portlets.admin.resourcemanagement.client.forms.genericresources;

import java.util.List;
import java.util.Vector;
import org.gcube.portlets.admin.resourcemanagement.client.remote.ProxyRegistry;
import org.gcube.portlets.admin.resourcemanagement.client.utils.Commands;
import org.gcube.portlets.admin.resourcemanagement.client.utils.OpCommands;


import org.gcube.resourcemanagement.support.client.utils.StatusHandler;
import org.gcube.resourcemanagement.support.client.views.ResourceTypeDecorator;
import org.gcube.resourcemanagement.support.client.views.validators.SelectValidator;
import org.gcube.resourcemanagement.support.shared.exceptions.InvalidParameterException;
import org.gcube.resourcemanagement.support.shared.types.Tuple;
import org.gcube.resourcemanagement.support.shared.types.datamodel.AtomicTreeNode;
import org.gcube.resourcemanagement.support.shared.types.datamodel.ResourceDescriptor;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.FormButtonBinding;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.form.ComboBox.TriggerAction;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;

enum StaticFields {
	VIEW_NAME("name", "e.g.: the name of the property", "e.g.: put here the name"),
	METADATA_NAME("schemaName", "e.g.: metadata prefix", "e.g.: FARM_dc"),
	METADATA_LANG("language", "e.g.: metadata language", "e.g.: en"),
	METADATA_SCHEMA("schemaURI", "e.g.: metadata schema", "e.g.: http://193.43.36.238:8282/fi/figis/devcon/schema/dc/qualifieddc.xsd"),
	IS_EDITABLE("isEditable", "e.g.: editable", "e.g.: true"),
	IS_INDEXABLE("isIndexable", "e.g.: indexable", "e.g.: true"),
	IS_USER_COLLECTION("isUserCollection", "e.g.: user collection", "e.g.: true");

	private String name = null;
	private String description = null;
	private String value = null;


	private StaticFields(final String name, final String description, final String value) {
		this.name = name;
		this.description = description;
		this.value = value;
	}


	public String getName() {
		return name;
	}

	public String getDescription() {
		return description;
	}

	public String getValue() {
		return value;
	}
}

public class ActivationRecordVMForm extends Dialog {
	private FormData formData = null;
	private FormPanel form = null;

	public ActivationRecordVMForm() {
		this.setLayout(new FitLayout());
		this.setHeading("Activation Record for VM");
		this.setModal(true);
		this.setWidth(700);
		this.setHeight(500);
		this.setResizable(false);
		this.getButtonBar().removeAll();
		this.setHideOnButtonClick(true);
	}

	@Override
	protected final void onRender(final Element parent, final int index) {
		super.onRender(parent, index);
		formData = new FormData("-20");
		createForm();
	}

	public final void closeDialog() {
		this.hide();
	}

	private void addStaticProperty(final String pfield, final String pdescription, final String pvalue) {
		final FieldSet fieldSet = new FieldSet();
		fieldSet.setLayout(new FormLayout());

		fieldSet.setHeading("Property");
		fieldSet.setCollapsible(false);

		TextField<String> name = new TextField<String>();
		name.setFieldLabel("Name");
		name.setValue(pfield);
		name.setEnabled(false);
		name.setAllowBlank(false);
		fieldSet.add(name, formData);

		TextField<String> description = new TextField<String>();
		description.setFieldLabel("Description");
		description.setEmptyText(pdescription);
		description.setAllowBlank(true);
		fieldSet.add(description, formData);

		TextField<String> value = new TextField<String>();
		value.setFieldLabel("Value");
		value.setEmptyText(pvalue);
		value.setAllowBlank(false);
		fieldSet.add(value, formData);

		form.add(fieldSet, formData);
		fieldSet.recalculate();
		this.doLayout(true);
	}

	private void addProperty() {
		final FieldSet fieldSet = new FieldSet();
		fieldSet.setLayout(new FormLayout());

		fieldSet.setHeading("Property");
		fieldSet.setCollapsible(false);

		TextField<String> name = new TextField<String>();
		name.setFieldLabel("Name");
		name.setAllowBlank(false);
		fieldSet.add(name, formData);

		TextField<String> description = new TextField<String>();
		description.setFieldLabel("Description");
		description.setAllowBlank(true);
		fieldSet.add(description, formData);

		TextField<String> value = new TextField<String>();
		value.setFieldLabel("Value");
		value.setAllowBlank(false);
		fieldSet.add(value, formData);

		final HorizontalPanel buttonPanel = new HorizontalPanel();
		Button addButton = new Button("Add New Property") {
			@Override
			protected void onClick(final ComponentEvent ce) {
				addProperty();
			}
		};
		addButton.setIconStyle("new-icon");
		buttonPanel.add(addButton);

		Button delButton = new Button("Remove This Property") {
			@Override
			protected void onClick(final ComponentEvent ce) {
				form.remove(fieldSet);
			}
		};
		delButton.setIconStyle("delete-icon");
		buttonPanel.add(delButton);
		fieldSet.add(buttonPanel, formData);

		form.add(fieldSet, formData);
		fieldSet.recalculate();
		this.doLayout(true);
	}

	private void createForm() {
		form = new FormPanel();
		form.setFrame(true);
		form.setAutoWidth(true);

		//form.setLayout(new FlowLayout());
		form.setScrollMode(Scroll.AUTO);

		form.setHeaderVisible(false);
		form.getHeader().setStyleName("x-hide-panel-header");

		TextField<String> resID = new TextField<String>();
		resID.setFieldLabel("Resource ID");
		resID.setEnabled(false);
		resID.setAllowBlank(true);  // is required

		resID.setEmptyText("<generated by Resource Manager>");

		form.add(resID, formData);

		TextField<String> resName = new TextField<String>();
		resName.setFieldLabel("Resource Name");
		resName.setValue("VMRecord");
		resName.setEnabled(false);
		//resName.setValidator(new StringValidator(20, false));
		resName.setAllowBlank(false);  // is required
		form.add(resName, formData);

		TextField<String> resType = new TextField<String>();
		resType.setFieldLabel("Secondary type");
		resType.setValue("ActivationRecord");
		resType.setEnabled(false);
		// resType.setValidator(new StringValidator(20, false));
		resType.setAllowBlank(false);  // is required
		form.add(resType, formData);

		TextArea description = new TextArea();
		description.setFieldLabel("Description");
		form.add(description, formData);

		ComboBox<ModelData> pluginSelect = new ComboBox<ModelData>();
		ListStore<ModelData> storePlugin = new ListStore<ModelData>();
		storePlugin.add(new AtomicTreeNode("Metadata"));
		storePlugin.add(new AtomicTreeNode("Annotation"));
		pluginSelect.setStore(storePlugin);
		pluginSelect.setFieldLabel("Plugin Kind:");
		pluginSelect.setEmptyText("Select a plugin...");
		pluginSelect.setTypeAhead(true);
		pluginSelect.setTriggerAction(TriggerAction.ALL);
		pluginSelect.setDisplayField("name");
		pluginSelect.setForceSelection(true);
		form.add(pluginSelect, formData);

		// The select for collections
		ComboBox<ResourceDescriptor> collectionSelect = new ComboBox<ResourceDescriptor>();
		ListStore<ResourceDescriptor> store = new ListStore<ResourceDescriptor>();
		try {
			store.add(new ResourceDescriptor("type", "subtype", "ID", "the name"));
		} catch (InvalidParameterException e) {
			e.printStackTrace();
		}
		collectionSelect.setStore(store);
		collectionSelect.setFieldLabel("Collection");
		collectionSelect.setEmptyText("Select a collection...");
		collectionSelect.setDisplayField("name");
		collectionSelect.setTypeAhead(true);
		collectionSelect.setTriggerAction(TriggerAction.ALL);
		collectionSelect.setForceSelection(true);
		collectionSelect.setData("text", "Select a collection");

		form.add(collectionSelect, formData);

		loadCollections(StatusHandler.getStatus().getCurrentScope(), collectionSelect);
		// -- ENDOF The select for collections

		// Inserts the static fields
		for (StaticFields entry : StaticFields.values()) {
			this.addStaticProperty(entry.getName(), entry.getDescription(), entry.getValue());
		}

		HorizontalPanel buttonPanel = new HorizontalPanel();
		Button addButton = new Button("Add New Property") {
			@Override
			protected void onClick(final ComponentEvent ce) {
				addProperty();
			}
		};
		addButton.setIconStyle("new-icon");
		buttonPanel.add(addButton);

		form.add(buttonPanel, formData);

		Button submitBtn = new Button("Submit") {
			@Override
			protected void onClick(final ComponentEvent ce) {
				super.onClick(ce);
				if (!form.isValid()) {
					return;
				}

				List<Field<?>> fields = form.getFields();

				// Creation mode
				// the parameter in position 0 is the
				// auto-generated ID.
				String resName = fields.get(1).getRawValue();
				String resType = fields.get(2).getRawValue();
				String description = fields.get(3).getRawValue();
				String plugin = fields.get(4).getRawValue() + "Plugin";
				String viewType = fields.get(4).getRawValue() + "View";
				String viewID = generateID();

				String collectionID = ((ResourceDescriptor) fields.get(5).getValue()).getID();

				// builds a list of tuples each one representing a single property
				// properties are supposed to be represented by three fields each one.
				List<Tuple<String>> properties = new Vector<Tuple<String>>();
				if (fields.size() > StaticFields.values().length - 1) {
					for (int i = StaticFields.values().length - 1; i < fields.size(); i = i + 3) {
						properties.add(new Tuple<String>(
								fields.get(i).getRawValue().trim(),
								(fields.get(i + 1).getRawValue() != null) ? fields.get(i + 1).getRawValue().trim() : "", // description can be null
										fields.get(i + 2).getRawValue().trim()));
					}
				} else {
					MessageBox.alert("Create Activation Form for VM", "No properties defined", null);
					return;
				}

				StringBuilder body = new StringBuilder();

				body.append("<ns4:Record xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\">");
				body.append("<createdBy xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\">ResourceManagementPortlet</createdBy>");
				body.append("<plugin xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\">" + plugin + "</plugin>");

				body.append("<view xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\">");

				body.append("<ns2:id xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\">" + viewID + "</ns2:id>");
				body.append("<ns2:collectionID xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\">" + collectionID + "</ns2:collectionID>");
				body.append("<ns2:type xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\">" + viewType + "</ns2:type>");
				body.append("<ns2:predicate xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\" />");
				body.append("<ns2:description xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\">" + fields.get(4).getRawValue() + " view for collection " + collectionID + "</ns2:description>");
				body.append("<ns2:cardinality xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\">0</ns2:cardinality>");
				body.append("<ns2:lastUpdate xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\">" + "2010-10-25T14:01:55.948+00:00" + "</ns2:lastUpdate>");

				for (Tuple<String> prop : properties) {
					body.append("<ns2:property xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\">");

					body.append("<ns2:name xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\">" + prop.get(0) + "</ns2:name>");
					body.append("<ns2:description xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\">" + prop.get(1) + "</ns2:description>");
					body.append("<ns2:value xmlns:ns4=\"http://gcube-system.org/namespaces/common\" xmlns:ns3=\"http://gcube-system.org/namespaces/contentmanagement/contentmanager\" xmlns:ns2=\"http://gcube-system.org/namespaces/contentmanagement/viewmanager\">" + prop.get(2) + "</ns2:value>");

					body.append("</ns2:property>");
				}

				body.append("</view>");
				body.append("</ns4:Record>");

				OpCommands.doCreateGenericResource(viewID, resName, description, body.toString(), resType);
				closeDialog();
			}
		};
		form.addButton(submitBtn);
		form.addButton(new Button("Cancel") {
			@Override
			protected void onClick(final ComponentEvent ce) {
				super.onClick(ce);
				closeDialog();
			}
		});

		form.setButtonAlign(HorizontalAlignment.CENTER);

		FormButtonBinding binding = new FormButtonBinding(form);
		binding.addButton(submitBtn);

		this.add(form);
	}

	private String generateID() {
		char[] s = new char[36];
		String itoh = "0123456789abcdef";

		// Make array of random hex digits. The UUID only has 32 digits in it, but we
		// allocate an extra items to make room for the '-'s we'll be inserting.
		for (int i = 0; i < 36; i++) {
			s[i] = (char) Math.floor(Math.random() * 0x10);
		}

		// Conform to RFC-4122, section 4.4
		s[14] = 4;  // Set 4 high bits of time_high field to version
		s[19] = (char) ((s[19] & 0x3) | 0x8);  // Specify 2 high bits of clock sequence

		// Convert to hex chars
		for (int i = 0; i < 36; i++) {
			s[i] = itoh.charAt((int) s[i]);
		}

		// Insert '-'s
		s[8] = s[13] = s[18] = s[23] = '-';
		return new String(s);
	}

	private void loadCollections(final String scope, final ComboBox<ResourceDescriptor> combo) {
		ProxyRegistry.getProxyInstance().getResourcesModel(scope,
				ResourceTypeDecorator.GenericResource.name(),
				"GCUBECollection",
				null,
				new AsyncCallback<List<ResourceDescriptor>>() {

			public void onSuccess(final List<ResourceDescriptor> result) {
				combo.getStore().removeAll();
				combo.getStore().add(result);

				combo.setValidator(new SelectValidator(false));
				combo.setAllowBlank(false);
				combo.setTriggerAction(TriggerAction.ALL);
				combo.recalculate();
				Commands.showPopup("Collection load", "Loaded (" + result.size() + ") Collections");
			}
			public void onFailure(final Throwable e) {
				MessageBox.alert("Error getting collections", e.getMessage(), null);
			}
		});
	}
}
