/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.resourcemanagement.client.widgets.console;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridGroupRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.grid.GroupingView;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.console.ConsoleMessage;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.console.ConsolePanel;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.panels.DetachablePanel;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.panels.ScrollablePanel;

public class ConsolePanel
implements DetachablePanel.DetachablePanelHandler {
    private GroupingStore<ConsoleMessage> store;
    private DetachablePanel rootPanel = null;
    private boolean enableGrouping = false;
    private Grid<ConsoleMessage> grid = null;
    private static final String collapsibleColumn = "type";

    public ConsolePanel(DetachablePanel rootPanel) {
        this.rootPanel = rootPanel;
        this.rootPanel.addHandler((DetachablePanel.DetachablePanelHandler)this);
        this.store = new GroupingStore();
        if (this.enableGrouping) {
            this.store.groupBy(collapsibleColumn);
        }
        this.store.sort("timestamp", Style.SortDir.DESC);
        this.onLoad();
    }

    private void onLoad() {
        this.grid = this.createGrid();
        ScrollablePanel gridContainer = new ScrollablePanel("console-grid-container", (Component)this.grid);
        this.rootPanel.insertMainWidget((Component)gridContainer);
        1 groupButton = new /* Unavailable Anonymous Inner Class!! */;
        groupButton.setIconStyle("grid-icon");
        this.rootPanel.getToolBar().add((Component)groupButton);
        2 clearButton = new /* Unavailable Anonymous Inner Class!! */;
        clearButton.setIconStyle("clear-icon");
        this.rootPanel.getToolBar().add((Component)clearButton);
    }

    private Grid<ConsoleMessage> createGrid() {
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        ColumnConfig column = new ColumnConfig();
        column.setId("timestamp");
        column.setHeader("Time");
        column.setWidth(105);
        configs.add(column);
        column = new ColumnConfig();
        column.setId("invoker");
        column.setHeader("Invoker");
        column.setWidth(420);
        configs.add(column);
        column = new ColumnConfig();
        column.setId(collapsibleColumn);
        column.setHeader("Type");
        column.setWidth(75);
        column.setRenderer((GridCellRenderer)new /* Unavailable Anonymous Inner Class!! */);
        configs.add(column);
        column = new ColumnConfig();
        column.setId("message");
        column.setHeader("Message");
        configs.add(column);
        ColumnModel cm = new ColumnModel(configs);
        GroupingView view = new GroupingView();
        view.setGroupRenderer((GridGroupRenderer)new /* Unavailable Anonymous Inner Class!! */);
        view.setShowGroupedColumn(false);
        Grid grid = new Grid((ListStore)this.store, cm);
        grid.setView((GridView)view);
        grid.setStyleAttribute("borderTop", "none");
        grid.setAutoExpandColumn("message");
        grid.setId("console-internal-grid");
        return grid;
    }

    public final boolean handle(ConsoleMessage event) {
        try {
            this.store.add((ModelData)event);
            this.store.commitChanges();
            return true;
        }
        catch (Exception e) {
            GWT.log((String)"During console handle", (Throwable)e);
            return false;
        }
    }

    public final void refresh() {
        this.rootPanel.layout(true);
        this.rootPanel.getRootPanel().sync(true);
        this.grid.sync(true);
        this.grid.getView().refresh(true);
        this.store.commitChanges();
        this.store.sort(this.store.getSortField(), this.store.getSortDir());
    }

    public final DetachablePanel getContainer() {
        return this.rootPanel;
    }

    public final Widget getWidget() {
        return this.grid;
    }

    public final void onDetachEvent(DetachablePanel container, Component content) {
        this.grid.getView().refresh(true);
    }

    public final void onEmbedEvent(DetachablePanel container, Component content) {
        this.grid.getView().refresh(true);
    }

    static /* synthetic */ boolean access$000(ConsolePanel x0) {
        return x0.enableGrouping;
    }

    static /* synthetic */ GroupingStore access$100(ConsolePanel x0) {
        return x0.store;
    }

    static /* synthetic */ boolean access$002(ConsolePanel x0, boolean x1) {
        x0.enableGrouping = x1;
        return x0.enableGrouping;
    }
}

