/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.resourcemanagement.client.views.resourcetree;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.TreePanelEvent;
import org.gcube.portlets.admin.resourcemanagement.client.utils.Commands;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.console.ConsoleMessageBroker;
import org.gcube.resourcemanagement.support.client.utils.StatusHandler;
import org.gcube.resourcemanagement.support.shared.types.datamodel.AtomicTreeNode;

class TreeSelectionListener
implements Listener<TreePanelEvent<ModelData>> {
    private boolean doExpand = false;

    TreeSelectionListener() {
    }

    public void handleEvent(TreePanelEvent<ModelData> be) {
        if (be.getType() == Events.Expand) {
            be.cancelBubble();
            this.doExpand = true;
            return;
        }
        if (be.getType() == Events.Collapse) {
            be.cancelBubble();
            this.doExpand = true;
            return;
        }
        if (be.getType() == Events.OnClick && !be.isRightClick() && be.getItem() != null && be.getItem() instanceof AtomicTreeNode) {
            if (!this.doExpand) {
                AtomicTreeNode selectedModel = (AtomicTreeNode)be.getItem();
                if (selectedModel != null && selectedModel.isLeaf()) {
                    ConsoleMessageBroker.trace((Object)this, (String)("Selected leaf: " + ((AtomicTreeNode)selectedModel.getParent()).getNode() + "::" + selectedModel.getName()));
                    Commands.doFilterResourceDetailsGrid((Object)this, (String)StatusHandler.getStatus().getCurrentScope(), (String)((AtomicTreeNode)selectedModel.getParent()).getNode(), (String)selectedModel.getSubType());
                }
                if (selectedModel != null && !selectedModel.isLeaf()) {
                    ConsoleMessageBroker.trace((Object)this, (String)("Selected node: " + selectedModel.getNode()));
                    Commands.doLoadResourceDetailsGrid((Object)this, (String)StatusHandler.getStatus().getCurrentScope(), (String)selectedModel.getNode());
                }
            }
            this.doExpand = false;
        }
    }
}

