/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.resourcemanagement.client.widgets.taskbar;

import com.google.gwt.core.client.GWT;
import java.util.HashMap;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.console.ConsoleMessageBroker;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.taskbar.TaskbarItem;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.taskbar.TaskbarWindow;
import org.gcube.resourcemanagement.support.client.views.ResourceTypeDecorator;

public class TaskbarRegister {
    static final HashMap<String, TaskbarItem> registeredItems = new HashMap();
    static TaskbarWindow lastOpenedWindow = null;

    public static int getCurrAddScopeReportsNumber() {
        int count = 0;
        for (String item : registeredItems.keySet()) {
            GWT.log((String)item);
            if (((TaskbarItem)registeredItems.get(item)).getType() != ResourceTypeDecorator.AddScopeReport) continue;
            ++count;
        }
        return count;
    }

    public static synchronized void setLastOpenedWindow(TaskbarWindow lastOpenedWindow) {
        TaskbarRegister.lastOpenedWindow = lastOpenedWindow;
    }

    public static synchronized TaskbarWindow getLastOpenedWindow() {
        return lastOpenedWindow;
    }

    public static synchronized void registerTaskbarWidget(String id, TaskbarItem item) {
        ConsoleMessageBroker.info(TaskbarRegister.class, (String)("Registering res: " + id));
        registeredItems.put(id, item);
    }

    public static synchronized void unregisterTaskbarWidget(String id) {
        ConsoleMessageBroker.info(TaskbarRegister.class, (String)("Unregistering res: " + id));
        registeredItems.remove(id);
    }

    public static synchronized TaskbarItem getTaskbarItem(String id) {
        if (registeredItems.containsKey(id)) {
            return (TaskbarItem)registeredItems.get(id);
        }
        return null;
    }

    public static synchronized boolean contains(String key) {
        return registeredItems.containsKey(key);
    }

    public static synchronized void minimizeAll() {
        Object[] items = registeredItems.values().toArray();
        ConsoleMessageBroker.trace(TaskbarRegister.class, (String)("Elems to remove: " + items.length));
        TaskbarItem curItem = null;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object elem = objectArray[n2];
            try {
                if (elem != null && !(curItem = (TaskbarItem)elem).getRelatedWindow().isMinimized()) {
                    curItem.getRelatedWindow().doMinimize();
                }
            }
            catch (Exception e) {
                GWT.log((String)"During remove all profiles", (Throwable)e);
                ConsoleMessageBroker.error(TaskbarRegister.class, (String)e.getMessage());
            }
            ++n2;
        }
        ConsoleMessageBroker.info(TaskbarRegister.class, (String)"Unregistering all resources");
    }

    public static synchronized void closeAll() {
        Object[] items = registeredItems.values().toArray();
        ConsoleMessageBroker.trace(TaskbarRegister.class, (String)("Elems to remove: " + items.length));
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object elem = objectArray[n2];
            try {
                if (elem != null) {
                    ((TaskbarItem)elem).getRelatedWindow().doClose();
                }
            }
            catch (Exception e) {
                GWT.log((String)"During remove all profiles", (Throwable)e);
                ConsoleMessageBroker.error(TaskbarRegister.class, (String)e.getMessage());
            }
            ++n2;
        }
        ConsoleMessageBroker.info(TaskbarRegister.class, (String)"Unregistering all resources");
        registeredItems.clear();
    }
}

