/****************************************************************************
 *  This software is part of the gCube Project.
 *  Site: http://www.gcube-system.org/
 ****************************************************************************
 * The gCube/gCore software is licensed as Free Open Source software
 * conveying to the EUPL (http://ec.europa.eu/idabc/eupl).
 * The software and documentation is provided by its authors/distributors
 * "as is" and no expressed or
 * implied warranty is given for its use, quality or fitness for a
 * particular case.
 ****************************************************************************
 * Filename: GenericTest.java
 ****************************************************************************
 * @author <a href="mailto:daniele.strollo@isti.cnr.it">Daniele Strollo</a>
 ***************************************************************************/

package org.gcube.resourcemanagement.support.tests;

import java.io.File;
import java.util.Map;

import org.gcube.common.core.contexts.GHNContext.Status;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScope.Type;
import org.gcube.resourcemanagement.support.managers.resources.GHNManager;
import org.gcube.resourcemanagement.support.managers.resources.GenericResourceManager;
import org.gcube.resourcemanagement.support.managers.resources.ResourceFactory;
import org.gcube.resourcemanagement.support.managers.scope.ScopeManager;
import org.gcube.resourcemanagement.support.types.AllowedResourceTypes;
import org.gcube.resourcemanagement.support.utils.ServerConsole;

/**
 * @author Daniele Strollo (ISTI-CNR)
 *
 */
public class GenericTest {
	private static final String LOG_PREFIX = "[SW-SUPPORT-TEST]";

	public static void testScope() {

		try {
			Map<String, GCUBEScope> scopes = ScopeManager.getAvailableScopes();

			System.out.println("\n\n\n******************** TEST SCOPE ***************\n");
			for (GCUBEScope scope : scopes.values()) {
				if ((scope.getType().compareTo(Type.INFRASTRUCTURE) == 0)
						|| (scope.getType().compareTo(Type.VO) == 0)) {
					if (scope.getServiceMap() != null) {
						ServerConsole.trace(null, "*** Map loaded for " + scope.getType() + " " + scope.toString() + " [OK]");
					} else {
						ServerConsole.trace(null, "*** Map loaded for " + scope.getType() + " " + scope.toString() + " [ERR]");
					}
				} else {
					try {
						if (scope.getEnclosingScope().getServiceMap() != null) {
							ServerConsole.trace(null, "*** Map loaded for " + scope.getType() + scope.toString() + " [OK]");
						}
					} catch (Exception e) {
						ServerConsole.trace(null, "*** Map loaded for " + scope.getType() + scope.toString() + " [ERR]");
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			System.out.println("\n******************** TEST SCOPE END ***************\n");
		}
	}

	public static String testCreation() {
		System.out.println("\n\n\n******************** TEST CREATION ***************");

		String resID = null;

		try {
			resID = GenericResourceManager.create(
					null,
					ScopeManager.getScope("/gcube/devsec"),
					"GR Test",
					"GR Test Description",
					"<TestBody>Hello</TestBody>",
			"XXX");
			ServerConsole.trace(null, "Generic Resource Created with ID: " + resID);
		} catch (Exception e) {
			ServerConsole.error(LOG_PREFIX, e);
		} finally {
			System.out.println("\n******************** TEST CREATION END ***************\n");
		}
		return resID;
	}

	public static void testScopeCopy(final String resID, final String fromScope, final String toScope) {
		System.out.println("\n\n\n******************** TEST SCOPE COPY ***************");
		try {
			GenericResourceManager res = new GenericResourceManager(resID);
			ServerConsole.trace(null,
					res.addToExistingScope(ScopeManager.getScope(fromScope), ScopeManager.getScope(toScope))
			);
		} catch (Exception e) {
			ServerConsole.error(LOG_PREFIX, e);
		} finally {
			System.out.println("\n******************** TEST SCOPE COPY END ***************\n");
		}
	}

	public static void testResourceEdit(final String resID, final GCUBEScope scope) {
		System.out.println("\n\n\n******************** TEST RESEDIT COPY ***************");
		try {
			GenericResourceManager res = new GenericResourceManager(resID);
			res.update("New Name", "updated description", null, null, scope);
		} catch (Exception e) {
			ServerConsole.error(LOG_PREFIX, e);
		} finally {
			System.out.println("\n******************** TEST RESEDIT END ***************\n");
		}
	}

	public static void testModeGHN(final String resID, final String scope)
	throws Exception {
		GCUBEScope queryScope = ScopeManager.getScope(scope);
		GHNManager ghnManager = new GHNManager(resID);
		GCUBEHostingNode res = (GCUBEHostingNode) ghnManager.getGCUBEResource(queryScope);
		res.getNodeDescription().setStatus(Status.UNREACHABLE);
		ghnManager.getISPublisher().updateGCUBEResource(res, queryScope, ghnManager.getSecurityManager());
	}

	public static void testGHN() {
		System.out.println("\n\n\n******************** TEST GHN ***************");
		try {
			GHNManager ghn1 = new GHNManager("20ddb210-b779-11df-96c9-a66904b26e27", "pc-strollo");
			ghn1.addToExistingScope(ScopeManager.getScope("/gcube"), ScopeManager.getScope("/gcube/devsec"));
		} catch (Exception e) {
			ServerConsole.error(LOG_PREFIX, e);
		} finally {
			System.out.println("\n******************** TEST GHN END ***************\n");
		}
	}

	public static void testRemoveFromScope(final String resID, final GCUBEScope scope) {
		System.out.println("\n\n\n******************** TEST RESOURCE REMOVEFROMSCOPE ***************");
		try {
			GenericResourceManager res = new GenericResourceManager(resID);
			res.removeFromScope(scope);
		} catch (Exception e) {
			ServerConsole.error(LOG_PREFIX, e);
		} finally {
			System.out.println("\n******************** TEST RESOURCE REMOVEFROMSCOPE END ***************\n");
		}
	}

	public static void testDelete(final String resID, final GCUBEScope scope) {
		System.out.println("\n\n\n******************** TEST RESOURCE DELETE ***************");
		try {
			GenericResourceManager res = new GenericResourceManager(resID);
			res.delete(scope);
		} catch (Exception e) {
			ServerConsole.error(LOG_PREFIX, e);
		} finally {
			System.out.println("\n******************** TEST RESOURCE DELETE END ***************\n");
		}
	}

	@SuppressWarnings("deprecation")
	public static void main(final String[] args) throws Exception {
		// The scopes must be initialized
		ScopeManager.setScopeConfigFile("test-suite" + File.separator + "scopes" + File.separator + "scopedata_admin.xml");

		boolean deepTest = false;
		// testScope();
		// testGHN();
		if (deepTest) {
			String resID = testCreation();
			testScopeCopy(resID, "/gcube/devsec", "/gcube/devsec/devVRE");

			System.out.println("\n\nWaiting for resource refresh 60secs.\n\n\n");
			Thread.sleep(60000);

			//testResourceEdit(resID, ScopeManager.getScope("/gcube/devsec"));
			testDelete(resID, ScopeManager.getScope("/gcube/devsec/devVRE"));

			// testRemoveFromScope(resID, ScopeManager.getScope("/gcube/devsec"));
		} else {
			testModeGHN("f5cb0640-f1a7-11df-93d0-fc409084cf46", "/gcube/devsec/devVRE");
		}
	}
}
