package org.gcube.portlets.admin.software_upload_wizard.server.softwaremanagers.softwaregateway;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.admin.software_upload_wizard.server.logging.InjectLogger;
import org.gcube.vremanagement.softwaregateway.client.RegisterProfileClient;
import org.slf4j.Logger;

public class DefaultSoftwareGatewayRegistrationManager implements
		ISoftwareGatewayRegistrationManager {

	@InjectLogger
	Logger logger;

	@Override
	public void registerProfile(String serviceProfileContent, GCUBEScope scope)
			throws Exception {
		logger.trace("Contacting Software Gateway using scope: '"
				+ scope.toString() + "'");
		logger.trace("Registering service profile:\n" + serviceProfileContent);
		String storeResult = null;
		try {
			storeResult = RegisterProfileClient.registerProfile(scope,
					serviceProfileContent);
		} catch (Exception e) {
			logger.error(
					"An error occured while registering the profile within the Software Gateway\n RegisterProfileClient returned: "
							+ storeResult, e);
			throw new Exception("Service profile registration failed.");
		}

		SoftwareGatewayRegistrationResult result;
		try {
			result = parseSoftwareGatewayResult(storeResult);
		} catch (Exception e) {
			logger.error(
					"An error occured while parsing the Software Gateway result",
					e);
			throw new Exception("Unable to parse Software Gateway response.");
		}

		if (result.getStatus() == SoftwareGatewayRegistrationResult.RegistrationStatus.ERROR) {
			logger.error("Service Profile registration failed. Software Gateway report:\n"
					+ result.getReport());
			throw new Exception("Service Profile registration failed.");
		}
		logger.debug("Software Profile registration succeeded");
	}

	private SoftwareGatewayRegistrationResult parseSoftwareGatewayResult(
			String result) {
		if (result.toLowerCase().contains(("<status>warn</status>"))
				|| result.toLowerCase().contains(("<status>success</status>")))
			return new SoftwareGatewayRegistrationResult(
					SoftwareGatewayRegistrationResult.RegistrationStatus.OK,
					result);
		return new SoftwareGatewayRegistrationResult(
				SoftwareGatewayRegistrationResult.RegistrationStatus.ERROR,
				result);
	}

}
