/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.gcubeloggedin.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portlets.user.gcubeloggedin.client.LoggedinService;
import org.gcube.portlets.user.gcubeloggedin.shared.VObject;
import org.gcube.portlets.user.gcubeloggedin.shared.VREClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggedinServiceImpl
extends RemoteServiceServlet
implements LoggedinService {
    private static final Logger _log = LoggerFactory.getLogger(LoggedinServiceImpl.class);
    private boolean isDeployed = true;

    private ASLSession getASLSession() {
        this.isDeployed = true;
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("LOGGEDIN PORTLET: USER IS NULL \n\n SESSION ID READ: " + sessionID);
            user = "test.user";
            _log.warn("session ID= *" + sessionID + "*  user= *" + user + "*");
            this.isDeployed = false;
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public VObject getSelectedRE() {
        ASLSession aslSession = this.getASLSession();
        if (!this.isDeployed) {
            return new VREClient("Test", "", "Fishery and Aquaculture Resources Management (FARM) Virtual Organisation</b>    The FARM Virtual Organisation is the <b><i>dynamic group of individuals</i></b> and/or <b><i>institutions</i></b>             defined around a set of <b><i>sharing rules</i></b> in which <b><i>resource providers</i></b> and <b><i>consumers</i></b>     specify clearly and carefully just what is shared, who is allowed to share, and the conditions under which sharing occurs to serve the needs of the     <b><i>Fisheries and Aquaculture Resources Management</i></b>.             This VO is conceived to support various application scenarios arising in the FARM Community including the production of Fisheries and Aquaculture Country Profiles, the management of catch statistics    including harmonisation, the dynamic generation of biodiversity maps and species distribution maps.            This Virtual Organisation currently consists of:<ul>                <li> approximately <b><i>13 gCube nodes</i></b>, i.e. machines dedicated to run the gCube system;</li>        <li> approximately <b><i>89 running instances</i></b>, i.e. running gCube services supporting the operation of the infrastructure;</li>        <li> approximately <b><i>25 collections</i></b>, i.e. set of D4Science Information Objects including Earth images, AquaMaps, Graphs on catch statistics;</li>        <li> approximately <b><i>66 metadata collections</i></b>, i.e. set of Metadata Objects describing the Information Objects through various features and schemas;</li>        <li> approximately <b><i>58 other resources</i></b> including transformation programs, index types, etc.</li></ul></div>", "", "", VObject.UserBelongingClient.BELONGING);
        }
        _log.trace("getting Selected Research Environment");
        HttpSession session = this.getThreadLocalRequest().getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
        Organization currOrg = (Organization)session.getAttribute("CURR_RE_NAME");
        aslSession.setAttribute("CURR_RE_NAME", (Object)currOrg);
        aslSession.setGroupModelInfos(currOrg.getName(), currOrg.getOrganizationId());
        _log.trace("CURRENT ORG SET IN SESSION: " + currOrg.getName());
        String name = currOrg.getName();
        long logoId = currOrg.getLogoId();
        String logoURL = themeDisplay.getPathImage() + "/organization_logo?img_id=" + logoId + "&t" + ImageServletTokenUtil.getToken((long)logoId);
        String desc = "";
        if (currOrg.getComments() != null) {
            desc = currOrg.getComments();
        }
        VREClient vre = new VREClient(name, "", desc, logoURL, "", VObject.UserBelongingClient.BELONGING);
        return vre;
    }

    public String getDefaultCommunityURL() {
        Properties props = new Properties();
        String comName = "";
        try {
            String propertyfile = this.getServletContext().getRealPath("") + "/config/resources.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            comName = props.getProperty("defaultcommunity");
        }
        catch (IOException e) {
            _log.error("/config/resources.properties not found, Returning \"Data e-Infrastructure gateway\" as default Community");
        }
        String toReturn = "";
        _log.trace("Default Community Read from config file: " + comName);
        Group myPlace = null;
        try {
            myPlace = GroupLocalServiceUtil.getGroup((long)OrganizationsUtil.getCompany().getCompanyId(), (String)comName);
            if (myPlace.isCommunity()) {
                ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
                toReturn = myPlace.getPathFriendlyURL(true, themeDisplay) + myPlace.getFriendlyURL();
            }
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        toReturn = this.getPortalBasicUrl() + toReturn;
        _log.trace("RETURNING Default Community URL: " + toReturn);
        return toReturn;
    }

    private String getPortalBasicUrl() {
        HttpServletRequest request = this.getThreadLocalRequest();
        String toReturn = "";
        String protocol = request.isSecure() ? "https://" : "http://";
        toReturn = toReturn + protocol;
        toReturn = toReturn + request.getServerName();
        toReturn = toReturn + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort());
        request.getQueryString();
        _log.trace("\n getPortalBasicUrl: " + toReturn + "queryString: " + request.getQueryString());
        return toReturn;
    }
}

