package org.gcube.portlets.user.gisviewer.server.datafeature.wfs;

import java.util.HashMap;
import java.util.Map;

import org.gcube.portlets.user.gisviewer.server.datafeature.wfs.WFSExporter.WFS_TO;
import org.gcube.portlets.user.gisviewer.shared.CSVFile;

public class FeatureExporterFileConfig {

	private CSVFile file;
	private Map<String, FeatureExportViewConfig> map = new HashMap<String, FeatureExportViewConfig>();
	private WFS_TO wfsTo;

	public FeatureExporterFileConfig() {
	}

	public FeatureExporterFileConfig(CSVFile file, Map<String, FeatureExportViewConfig> map, WFS_TO wfsTo) {
		super();
		this.file = file;
		this.map = map;
		this.wfsTo = wfsTo;
	}

	public WFS_TO getWfsTo() {
		return wfsTo;
	}

	public void setWfsTo(WFS_TO wfsTo) {
		this.wfsTo = wfsTo;
	}

	public CSVFile getFile() {
		return file;
	}

	public void setFile(CSVFile file) {
		this.file = file;
	}

	public Map<String, FeatureExportViewConfig> getMap() {
		return map;
	}

	public void setMap(Map<String, FeatureExportViewConfig> map) {
		this.map = map;
	}

	@Override
	public String toString() {
		return "FeatureExporterFileConfig [file=" + file + ", map=" + map + ", wfsTo=" + wfsTo + "]";
	}

	

}
