/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.Validate;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.portlets.user.homelibrary.util.Util;

public class JCRMetadata
extends JCRWorkspaceFolderItem
implements Metadata {
    private static final String SCHEMA = "hl:schema";
    private static final String LANGUAGE = "hl:language";
    private static final String COLLECTION_NAME = "hl:collectionName";
    private static final String OID = "hl:oid";
    private static final String NT_CONTENT = "nthl:metadataItemContent";
    private final String schema;
    private final String language;
    private final String collectionName;
    private final String oid;
    private final JCRFile file;

    public JCRMetadata(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
        super(workspace, node);
        Node contentNode = node.getNode("jcr:content");
        this.schema = contentNode.getProperty(SCHEMA).getString();
        this.language = contentNode.getProperty(LANGUAGE).getString();
        this.collectionName = contentNode.getProperty(COLLECTION_NAME).getString();
        this.oid = contentNode.getProperty(OID).getString();
        this.file = new JCRFile(contentNode);
    }

    public JCRMetadata(JCRWorkspace workspace, Node node, String name, String description, String objectId, String schema, String language, String collectionName, String data) throws RepositoryException {
        super(workspace, node, name, description);
        Validate.notNull((Object)objectId, (String)"Oid must be not null");
        Validate.notNull((Object)schema, (String)"Schema must be not null");
        Validate.notNull((Object)language, (String)"Language must be not null");
        Validate.notNull((Object)collectionName, (String)"Collection name must be not null");
        Validate.notNull((Object)data, (String)"Data must be not null");
        this.schema = schema;
        this.language = language;
        this.collectionName = collectionName;
        this.oid = objectId;
        node.setProperty("hl:workspaceItemType", FolderItemType.DOCUMENT.toString());
        Node contentNode = node.addNode("jcr:content", NT_CONTENT);
        contentNode.setProperty(SCHEMA, schema);
        contentNode.setProperty(LANGUAGE, language);
        contentNode.setProperty(COLLECTION_NAME, collectionName);
        contentNode.setProperty(OID, objectId);
        this.file = new JCRFile(contentNode, new ByteArrayInputStream(data.getBytes()));
    }

    public String getSchema() {
        return this.schema;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getData() {
        try {
            return Util.readStreamAsString((InputStream)this.file.getData());
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.METADATA;
    }

    public String getURI() {
        return this.oid;
    }

    @Override
    public long getLength() {
        try {
            return this.file.getLength();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public void saveContent(Node node) throws RepositoryException {
        this.file.save(node);
    }
}

