/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.HomeManagerFactory;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.portlets.user.homelibrary.jcr.JCRUser;
import org.gcube.portlets.user.homelibrary.jcr.home.JCRHome;
import org.gcube.portlets.user.homelibrary.util.accesslog.AccessLogUtil;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.UserModel;

public class JCRHomeManager
implements HomeManager {
    private Map<String, JCRUser> users = new LinkedHashMap<String, JCRUser>();
    private Map<String, JCRHome> userHomesLogged = new LinkedHashMap<String, JCRHome>();
    private HomeManagerFactory factory;
    private final File persistenceFoolder;
    private static GCUBEClientLog logger;

    public JCRHomeManager(HomeManagerFactory factory, File persistenceFolder) {
        logger = new GCUBEClientLog((Object)this, new Properties[0]);
        this.persistenceFoolder = persistenceFolder;
        this.factory = factory;
        this.createUsers();
    }

    private void createUsers() {
        GHNContext ctx = GHNContext.getContext();
        String rootOrgName = (String)ctx.getProperty("infrastructure", new boolean[]{true});
        LiferayGroupManager gm = new LiferayGroupManager();
        LiferayUserManager um = new LiferayUserManager();
        try {
            logger.debug((Object)"Start import portal users");
            for (UserModel model : um.listUsersByGroup(gm.getGroupId(rootOrgName))) {
                this.createUser(model.getScreenName());
                logger.debug((Object)("User " + model.getScreenName() + " imported"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Users not retrieved", (Throwable)e);
        }
    }

    public HomeManagerFactory getHomeManagerFactory() {
        return this.factory;
    }

    public List<User> getUsers() {
        return new LinkedList<User>(this.users.values());
    }

    public User getUser(String portalLogin) throws InternalErrorException {
        logger.info((Object)("getUser portalLogin: " + portalLogin));
        return this.createUser(portalLogin);
    }

    public synchronized boolean existUser(String portalLogin) throws InternalErrorException {
        logger.trace((Object)("existUser portalLogin: " + portalLogin));
        if (portalLogin == null) {
            logger.error((Object)"portalLogin null");
            throw new IllegalArgumentException("The portalLogin value is null");
        }
        return this.users.containsKey(portalLogin);
    }

    public synchronized User createUser(String portalLogin) throws InternalErrorException {
        JCRUser user = this.users.get(portalLogin);
        if (user == null) {
            logger.info((Object)("User " + portalLogin + " not found, creating a new one."));
            user = new JCRUser(UUID.randomUUID().toString(), portalLogin, null);
            logger.info((Object)("User created: " + user));
            this.users.put(portalLogin, user);
        }
        return user;
    }

    public Home getHome(User user, GCUBEScope scope) throws InternalErrorException, HomeNotFoundException {
        JCRHome home;
        logger.info((Object)("getHome user: " + user));
        if (this.userHomesLogged.containsKey(user.getPortalLogin())) {
            logger.debug((Object)" User is already logged");
            JCRHome home2 = this.userHomesLogged.get(user.getPortalLogin());
            if (scope != null) {
                home2.setScope(scope);
            }
            return home2;
        }
        try {
            ((JCRUser)user).setScope(scope);
            home = new JCRHome(this, (JCRUser)user, this.persistenceFoolder);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        this.userHomesLogged.put(user.getPortalLogin(), home);
        logger.trace((Object)"User loaded.");
        if (user.getScope() != null) {
            AccessLogUtil.logWorkspaceCreated((User)user);
        }
        return home;
    }

    public Home getHome(String portalLogin, GCUBEScope scope) throws InternalErrorException, HomeNotFoundException, UserNotFoundException {
        logger.info((Object)("getHome portalLogin: " + portalLogin));
        User user = this.getUser(portalLogin);
        return this.getHome(user, scope);
    }

    public synchronized void removeUser(User user) throws InternalErrorException {
        this.userHomesLogged.remove(user.getPortalLogin());
    }
}

