/**
 * 
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.accounting;

import java.util.Calendar;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryRenaming;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryType;

/**
 * @author Antonio Gioia antonio.gioia@isti.cnr.it
 *
 */
public class JCRAccountingEntryRenaming extends JCRAccountingEntry implements AccountingEntryRenaming{

	private static final String OLD_ITEM_NAME = "hl:oldItemName";
	
	private final String oldItemName;
	
	public JCRAccountingEntryRenaming(Node node) throws RepositoryException {
		super(node);
		
		this.oldItemName = node.getProperty(OLD_ITEM_NAME).getString();
	}
	
	public JCRAccountingEntryRenaming(String user, Calendar date,
			String oldItemName) {
		super(user, date);
		
		this.oldItemName = oldItemName;
	}

	@Override
	public String getOldItemName() {
		return oldItemName;
	}
	
	@Override
	public void save(Node entryNode) throws RepositoryException{
		super.save(entryNode);
		
		entryNode.setProperty(OLD_ITEM_NAME, oldItemName);
		
	}

	@Override
	public AccountingEntryType getEntryType() {
		
		return AccountingEntryType.RENAMING;
	}
	
	@Override
	public String toString() {
		String parentValue = super.toString();
		return String.format("[%s [%s oldItemName:%s]]",parentValue, AccountingEntryType.RENAMING, oldItemName);
	}

}
