package org.gcube.portlets.user.homelibrary.jcr.workspace.search;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.search.SearchFolder;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceItem;

public class JCRSearchFolder implements SearchFolder {
	
	private final String id;
	private final Calendar creationDate;
	
	protected String name;

	public JCRSearchFolder(Node node, String name) throws RepositoryException{
		
		this.id = node.getIdentifier();
		this.name = name;
		this.creationDate = node.getProperty(JCRWorkspaceItem.CREATED).getDate();
	}
	
	
	@Override
	public String getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public Calendar getCreationDate() {
		return creationDate;
	}

	@Override
	public WorkspaceItemType getType() {
		
		return WorkspaceItemType.FOLDER;
	}
	
}
