package org.gcube.portlets.user.homelibrary.jcr.data;

import java.util.List;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.gcube.portlets.user.homelibrary.home.data.ApplicationsArea;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceFolder;

public class JCRApplicationsArea implements ApplicationsArea {

	private String rootId;
	
	private JCRWorkspaceFolder applicationsArea;
	
	private JCRWorkspace worksapce;
	
	public JCRApplicationsArea(JCRWorkspace workspace) {
		this.worksapce = workspace;
		
		Session session = null;
		try {
			
			session =  JCRRepository.getSession();
			Node node =  JCRRepository.getApplicationsRoot(session);
			applicationsArea = new JCRWorkspaceFolder(workspace, node);
			
		} catch (InternalErrorException e) {
			
		} catch (RepositoryException e) {
			
		} finally {
			session.logout();
		}
	}
	
	private WorkspaceFolder getApplicationRoot(Session session, String applicationName) throws InternalErrorException {
		
		try {
			
			WorkspaceFolder folder = (WorkspaceFolder)applicationsArea.find(applicationName);
			if (folder == null)
				folder = applicationsArea.createFolder(applicationName, applicationName);
			
			return folder;
		} catch (InsufficientPrivilegesException e) {
			throw new InternalErrorException(e);
		} catch (ItemAlreadyExistException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}
	
	@Override
	public WorkspaceFolder getApplicationRoot(Class<?> applicationClass)
			throws InternalErrorException {
		
		Session session = JCRRepository.getSession();
		return getApplicationRoot(session, applicationClass.getName());
		
	}
		
	@Override
	public List<String> listApplicationNames() throws InternalErrorException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public WorkspaceFolder getApplicationUserRoot(Class<?> applicationClass)
			throws InternalErrorException {
		
		Session session = JCRRepository.getSession();
		WorkspaceFolder applicationsRoot = getApplicationRoot(applicationClass);
		try {
			WorkspaceFolder userFolder = (WorkspaceFolder)applicationsRoot.find(worksapce.getOwner().getPortalLogin());
			if (userFolder == null)
				userFolder = applicationsRoot.createFolder(applicationClass.getName(), applicationClass.getName());
			return userFolder;
		} catch (InsufficientPrivilegesException e) {
			throw new InternalErrorException(e);
		} catch (ItemAlreadyExistException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}
	
}
