/**
 * 
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.accounting;

import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntry;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryRead;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryType;

/**
 * @author Antonio Gioia antonio.gioia@isti.cnr.it
 *
 */
public class JCRAccountingEntryRead implements AccountingEntryRead {

	private static final String DATE				= "hl:date";
	
	private final String user;
	private final Calendar date;

	
	public JCRAccountingEntryRead(Node node) throws RepositoryException {
		
		this.user = node.getName();
		this.date = node.getProperty(DATE).getDate();	
	}
	
	public JCRAccountingEntryRead(String user, Calendar date) {
		
		this.user = user;
		this.date = date;
	}
	
	@Override
	public String getUser() {
		return user;
	}

	@Override
	public Calendar getDate() {
		return date;
	}

	public void save(Node entryNode) throws RepositoryException  {
		entryNode.setProperty(DATE, date);	
	}

	@Override
	public AccountingEntryType getEntryType() {

		return AccountingEntryType.READ;
	}
	
	@Override
	public String toString() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return String.format("[ user:%s, date:%s ]",user,sdf.format(date.getTime()));
	}

}
